% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OU.R
\name{dTpdOu}
\alias{dTpdOu}
\alias{meantOu}
\alias{vartOu}
\alias{covstOu}
\title{Transition probability density of the univariate OU diffusion}
\usage{
dTpdOu(x, x0, t, alpha, mu, sigma, log = FALSE)

meantOu(x0, t, alpha, mu)

vartOu(t, alpha, sigma)

covstOu(s, t, alpha, sigma)
}
\arguments{
\item{x}{vector with the evaluation points.}

\item{x0}{initial point.}

\item{t, s}{time between observations.}

\item{alpha}{strength of the drift.}

\item{mu}{unconditional mean of the diffusion.}

\item{sigma}{diffusion coefficient.}

\item{log}{flag to indicate whether to compute the logarithm of the density.}
}
\value{
A vector of the same length as \code{x} containing the evaluation of the density.
}
\description{
Transition probability density of the \emph{univariate} Ornstein--Uhlenbeck (OU) diffusion
\deqn{dX_t=\alpha(\mu - X_t)dt+\sigma dW_t, X_0=x_0.}{dX_t=alpha(mu - X_t)dt+sigma dW_t, X0=x0.}
}
\details{
The transition probability density is a normal density with mean \code{\link{meantOu}} and variance \code{\link{vartOu}}. See \code{\link{dTpdMou}} for the multivariate case (less efficient for dimension one).
}
\examples{
x <- seq(-4, 4, by = 0.01)
plot(x, dTpdOu(x = x, x0 = 3, t = 0.1, alpha = 1, mu = -1, sigma = 1),
     type = "l", ylim = c(0, 1.5), xlab = "x", ylab = "Density",
     col = rainbow(20)[1])
for (i in 2:20) {
  lines(x, dTpdOu(x = x, x0 = 3, t = i / 10, alpha = 1, mu = -1, sigma = 1),
        col = rainbow(20)[i])
}
}
