% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmi.R
\name{lmi3}
\alias{lmi3}
\title{Linear Matrix Inequality 3}
\usage{
lmi3(A, B, G)
}
\arguments{
\item{A}{An nxn real valued matrix}

\item{B}{An mxn real valued matrix}

\item{G}{An nxn real valued matrix}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant c matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{lmi3} creates input for sqlp to solve a linear matrix inequality problem
}
\details{
Solves the type-3 linear matrix inequality problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
A <- matrix(c(-1,0,1,0,-2,1,0,0,-1),3,3)
B <- matrix(c(1,2,3,4,5,6), 2, 3)
G <- matrix(1,3,3)

out <- lmi3(A,B,G)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

}

