% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmi.R
\name{lmi3}
\alias{lmi3}
\title{Linear Matrix Inequality 3}
\usage{
lmi3(A, B, G)
}
\arguments{
\item{A}{An nxn real valued matrix}

\item{B}{An mxn real valued matrix}

\item{G}{An nxn real valued matrix}
}
\value{
\item{X}{A list containing the solution matrix to the primal problem}
\item{y}{A list containing the  solution vector to the dual problem}
\item{Z}{A list containing the  solution matrix to the dual problem}
\item{pobj}{The achieved value of the primary objective function}
\item{dobj}{The achieved value of the dual objective function}
}
\description{
\code{lmi3} creates input for sqlp to solve a linear matrix inequality problem
}
\details{
Solves the type-3 linear matrix inequality problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
A <- matrix(c(-1,0,1,0,-2,1,0,0,-1),3,3)
B <- matrix(c(1,2,3,4,5,6), 2, 3)
G <- matrix(1,3,3)

out <- lmi3(A,B,G)

}
