% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qs.R
\name{qs}
\alias{qs}
\title{QS test}
\usage{
qs(x, freq = NA, diff = T, residuals = F, autoarima = T)
}
\arguments{
\item{x}{time series}

\item{freq}{Frequency of the time series}

\item{diff}{Shall the differenced series be tested?}

\item{residuals}{Shall the residuals of ARIMA model be tested?}

\item{autoarima}{Use automatic instead of a (0,1,1) ARIMA model?}
}
\description{
Test for seasonality in a time series.
}
\details{
If residuals=FALSE the autoarima settings are ignored.

If residuals=TRUE, a non-seasonal ARIMA model is estimated for the time series. And the residuals of the fitted model are used as input to the test statistic. If an automatic order selection is used, the Hyndman-Khandakar algorithm is employed with max(p)=max(q) <= 3.
}
\examples{
qs(ts(rnorm(120, 10,10), frequency=12))
qs(ts(rnorm(1200, 10,10), frequency=7))
}
\references{
Hyndman, R. J. and Y. Khandakar (2008). Automatic Time Series Forecasting: The forecast Package for R. Journal of Statistical Software 27 (3), 1-22.

Maravall, A. (2011). Seasonality Tests and Automatic Model Identification in TRAMO-SEATS. Bank of Spain.
}
\author{
Daniel Ollech
}
