% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{sha256}
\alias{sha256}
\title{Cryptographic Hashing Using the SHA-256 Algorithm}
\usage{
sha256(x, convert = TRUE, file)
}
\arguments{
\item{x}{R object to hash. A character string or raw vector (without
attributes) is hashed 'as is'. All other objects are hashed using R
serialization in a memory-efficient 'streaming' manner, without
allocation of the serialized object. To ensure portability, serialization
v3 XDR is always used with headers skipped (as these contain R version
and encoding information).}

\item{convert}{[default TRUE] if TRUE, the hash is converted to its hex
representation as a character string, if FALSE, output directly as a raw
vector, or if NA, a vector of (32-bit) integer values.}

\item{file}{character file name / path. If specified, 'x' is ignored. The
file is hashed in a streaming fashion and may be larger than memory.}
}
\value{
A character string, raw or integer vector depending on 'convert'.
}
\description{
Returns a SHA-256 hash of the supplied R object or file.
}
\examples{
# SHA-256 hash as character string:
sha256("secret base")

# SHA-256 hash as raw vector:
sha256("secret base", convert = FALSE)

# SHA-256 hash a file:
file <- tempfile(); cat("secret base", file = file)
sha256(file = file)
unlink(file)

}
