% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secret.R
\name{shake256}
\alias{shake256}
\title{SHAKE256 Extendable Output Function}
\usage{
shake256(x, bits = 256L, convert = TRUE, file)
}
\arguments{
\item{x}{object to hash. A character string or raw vector (without
attributes) is hashed as is. All other objects are stream hashed using
native R serialization.}

\item{bits}{integer output size of the returned hash. Value must be between 8
and 2^24.}

\item{convert}{logical \code{TRUE} to convert the hash to its hex representation
as a character string, \code{FALSE} to return directly as a raw vector, or \code{NA}
to return as a vector of (32-bit) integers.}

\item{file}{character file name / path. If specified, \code{x} is ignored. The
file is stream hashed, and the file can be larger than memory.}
}
\value{
A character string, raw or integer vector depending on \code{convert}.
}
\description{
Returns a SHAKE256 hash of the supplied object or file.
}
\details{
To produce single integer values suitable for use as random seeds for R's
pseudo random number generators (RNGs), set \sQuote{bits} to 32 and
\sQuote{convert} to NA.
}
\section{R Serialization Stream Hashing}{


Where this is used, serialization is always version 3 big-endian
representation and the headers (containing R version and native encoding
information) are skipped to ensure portability across platforms.

As hashing is performed in a streaming fashion, there is no materialization
of, or memory allocation for, the serialized object.
}

\examples{
# SHAKE256 hash as character string:
shake256("secret base")

# SHAKE256 hash as raw vector:
shake256("secret base", convert = FALSE)

# SHAKE256 hash to integer:
shake256("secret base", bits = 32L, convert = NA)

# SHAKE256 hash a file:
file <- tempfile(); cat("secret base", file = file)
shake256(file = file)
unlink(file)

}
\references{
This implementation is based on one by 'The Mbed TLS Contributors' under the
'Mbed TLS' Trusted Firmware Project at
\url{https://www.trustedfirmware.org/projects/mbed-tls}.
}
