% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_secsse_eval.R
\name{cla_secsse_eval}
\alias{cla_secsse_eval}
\title{Likelihood for SecSSE model, using Rcpp}
\usage{
cla_secsse_eval(
  parameter,
  phy,
  traits,
  num_concealed_states,
  ancestral_states,
  num_steps = NULL,
  cond = "proper_cond",
  root_state_weight = "proper_weights",
  sampling_fraction,
  setting_calculation = NULL,
  loglik_penalty = 0,
  is_complete_tree = FALSE,
  method = "odeint::bulirsch_stoer",
  atol = 1e-16,
  rtol = 1e-16,
  verbose = FALSE
)
}
\arguments{
\item{parameter}{list where the first is a table where lambdas across
different modes of speciation are shown, the second mus and the third
 transition rates.}

\item{phy}{phylogenetic tree of class phylo, ultrametric, fully-resolved,
rooted and with branch lengths.}

\item{traits}{vector with trait states, order of states must be the same as
tree tips, for help, see vignette.}

\item{num_concealed_states}{number of concealed states, generally equivalent
to number of examined states.}

\item{ancestral_states}{ancestral states matrix provided by
cla_secsse_loglik, this is used as starting points for manual integration}

\item{num_steps}{number of steps to integrate along a branch}

\item{cond}{condition on the existence of a node root: 'maddison_cond',
'proper_cond'(default). For details, see vignette.}

\item{root_state_weight}{the method to weigh the states:'maddison_weigh
,'proper_weights'(default) or 'equal_weights'. It can also be specified the
root state:the vector c(1,0,0) indicates state 1 was the root state.}

\item{sampling_fraction}{vector that states the sampling proportion per trait
state. It must have as many elements as trait states.}

\item{setting_calculation}{argument used internally to speed up calculation.
It should be leave blank (default : setting_calculation = NULL)}

\item{loglik_penalty}{the size of the penalty for all parameters; default is
0 (no penalty)}

\item{is_complete_tree}{whether or not a tree with all its extinct species is
provided}

\item{method}{integration method used, available are:
"odeint::runge_kutta_cash_karp54", "odeint::runge_kutta_fehlberg78",
"odeint::runge_kutta_dopri5", "odeint::bulirsch_stoer" and
"odeint::runge_kutta4". Default method is:"odeint::bulirsch_stoer".}

\item{atol}{absolute tolerance of integration}

\item{rtol}{relative tolerance of integration}

\item{verbose}{provide intermediate verbose output if TRUE}
}
\value{
The loglikelihood of the data given the parameters
}
\description{
Using see_ancestral_states = TRUE in the function
cla_secsse_loglik will provide posterior probabilities of the states of the
model on the nodes of the tree, but will not give the values on the branches.
This function evaluates these probabilities at fixed time intervals dt.
Because dt is fixed, this may lead to some inaccuracies, and dt is best
chosen as small as possible.
}
\details{
Evaluation of probabilities of observing states along branches.
}
