% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secsse_utils.R
\name{prepare_full_lambdas}
\alias{prepare_full_lambdas}
\title{Prepares the entire set of lambda matrices for cla_secsse.}
\usage{
prepare_full_lambdas(traits, num_concealed_states, lambd_and_modeSpe)
}
\arguments{
\item{traits}{vector with trait states, order of states must be the same as
tree tips, for help, see vignette.}

\item{num_concealed_states}{number of concealed states, generally equivalent
to number of examined states.}

\item{lambd_and_modeSpe}{a matrix with the 4 models of speciation possible.}
}
\value{
A list of lambdas, its length would be the same than the number of
trait states * num_concealed_states..
}
\description{
It provides the set of matrices containing all the speciation rates
}
\examples{
set.seed(13)
phylotree <- ape::rcoal(12, tip.label = 1:12)
traits <- sample(c(0, 1, 2),
                 ape::Ntip(phylotree), replace = TRUE)
num_concealed_states <- 3
# the idparlist for a ETD model (dual state inheritance model of evolution)
# would be set like this:
idparlist <- secsse::cla_id_paramPos(traits, num_concealed_states)
lambd_and_modeSpe <- idparlist$lambdas
lambd_and_modeSpe[1, ] <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
idparlist[[1]] <- lambd_and_modeSpe
idparlist[[2]][] <- 0
masterBlock <- matrix(4, ncol = 3, nrow = 3, byrow = TRUE)
diag(masterBlock) <- NA
idparlist[[3]] <- q_doubletrans(traits, masterBlock, diff.conceal = FALSE)
# Now, internally, clasecsse sorts the lambda matrices, so they look like
#  a list with 9 matrices, corresponding to the 9 states
# (0A,1A,2A,0B, etc)

parameter <- idparlist
lambda_and_modeSpe <- parameter$lambdas
lambda_and_modeSpe[1, ] <- c(0.2, 0.2, 0.2, 0.4, 0.4, 0.4, 0.01, 0.01, 0.01)
parameter[[1]] <- prepare_full_lambdas(traits, num_concealed_states,
                                       lambda_and_modeSpe)
}
