# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

nzcount <- function(x) {
    .Call('secure_nzcount', PACKAGE = 'secure', x)
}

wpow <- function(x, gamma0) {
    .Call('secure_wpow', PACKAGE = 'secure', x, gamma0)
}

softThres <- function(x, lambda) {
    .Call('secure_softThres', PACKAGE = 'secure', x, lambda)
}

#' Linear constrained Penalized regression with elastic net penalty
#'
#' @param XY X'Y where X is covariance matrix and Y response vector
#' @param XX  X'X where X is covariance matrix
#' @param A linear constraint parameter A
#' @param B linear constraint parameter
#' @param Lambda1 lasso penalty parameter
#' @param Lambda2 elastic net penalty parameter
#' @param Mu linear constraint strength
#' @param Nu multiplicative factor for linear constraint strength
#' @param Beta0 initial value of regression coefficient vector
#' @param control a list of parameters controling the fitting process
#' @return estimated regression coefficient vector
bregpcdenet_Rcpp <- function(XY, XX, A, B, Lambda1, Lambda2, Mu, Nu, Beta0, control) {
    .Call('secure_bregpcdenet_Rcpp', PACKAGE = 'secure', XY, XX, A, B, Lambda1, Lambda2, Mu, Nu, Beta0, control)
}

#' Linear constrained Penalized regression with elastic net penalty when X is orthogonal
#'
#' @param XY X'Y where X is covariance matrix and Y response vector
#' @param XX  X'X where X is covariance matrix
#' @param A linear constraint parameter A
#' @param B linear constraint parameter
#' @param Lambda1 lasso penalty parameter
#' @param Lambda2 elastic net penalty parameter
#' @param Mu linear constraint strength
#' @param Nu multiplicative factor for linear constraint strength
#' @param Beta0 initial value of regression coefficient vector
#' @param control a list of parameters controling the fitting process
#' @return estimated regression coefficient vector
bregpcdenetdiag_Rcpp <- function(XY, XX, A, B, Lambda1, Lambda2, Mu, Nu, Beta0, control) {
    .Call('secure_bregpcdenetdiag_Rcpp', PACKAGE = 'secure', XY, XX, A, B, Lambda1, Lambda2, Mu, Nu, Beta0, control)
}

#' Sparse unit-rank regression, Rcpp version
#' @param X covariate matrix
#' @param Y response matrix
#' @param Au responsible for orthogonality constraint on XU
#' @param Av responsible for orthogonality constraint on V
#' @param bu responsible for orthogonality constraint on XU
#' @param bv responsible for orthogonality constraint on V
#' @param uk initial value of kth column of U
#' @param vk initial value of kth column of V
#' @param dk initial value of kth diagonal value of D
#' @param nlambda number of lambda to be specified in solution path
#' @param control a list of parameters controlling the fitting process
#' @return S3 \code{sefar_SURR_Rcpp} object .....
sefar_SURR_Rcpp <- function(X, Y, Au, Av, bu, bv, uk, vk, dk, nlambda, control) {
    .Call('secure_sefar_SURR_Rcpp', PACKAGE = 'secure', X, Y, Au, Av, bu, bv, uk, vk, dk, nlambda, control)
}

#' Sparse unit-rank regression when X is orthogonal, Rcpp version
#' @param X covariate matrix
#' @param Y response matrix
#' @param Au responsible for orthogonality constraint on XU
#' @param Av responsible for orthogonality constraint on V
#' @param bu responsible for orthogonality constraint on XU
#' @param bv responsible for orthogonality constraint on V
#' @param uk initial value of kth column of U
#' @param vk initial value of kth column of V
#' @param dk initial value of kth diagonal value of D
#' @param nlambda number of lambda to be specified in solution path
#' @param control a list of parameters controlling the fitting process
#' @return S3 \code{sefar_SURR_Rcpp_ortho} object .....
sefar_SURR_Rcpp_ortho <- function(X, Y, Au, Av, bu, bv, uk, vk, dk, nlambda, control) {
    .Call('secure_sefar_SURR_Rcpp_ortho', PACKAGE = 'secure', X, Y, Au, Av, bu, bv, uk, vk, dk, nlambda, control)
}

#' Sparse unit-rank regression when missing entries in Y, Rcpp version
#' @param X covariate matrix
#' @param Y response matrix
#' @param naInd Missing entries indicator matrix
#' @param Au responsible for orthogonality constraint on XU
#' @param Av responsible for orthogonality constraint on V
#' @param bu responsible for orthogonality constraint on XU
#' @param bv responsible for orthogonality constraint on V
#' @param uk initial value of kth column of U
#' @param vk initial value of kth column of V
#' @param dk initial value of kth diagonal value of D
#' @param nlambda number of lambda to be specified in solution path
#' @param control a list of parameters controlling the fitting process
#' @return S3 \code{sefar_SURR_miss_Rcpp} object .....
sefar_SURR_miss_Rcpp <- function(X, Y, naInd, Au, Av, bu, bv, uk, vk, dk, nlambda, control) {
    .Call('secure_sefar_SURR_miss_Rcpp', PACKAGE = 'secure', X, Y, naInd, Au, Av, bu, bv, uk, vk, dk, nlambda, control)
}

