% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_material.R
\name{scale_color_material}
\alias{scale_color_material}
\alias{scale_color_material_d}
\alias{scale_color_material_c}
\alias{scale_colour_material}
\alias{scale_colour_material_c}
\alias{scale_colour_material_d}
\alias{scale_fill_material}
\alias{scale_fill_material_d}
\alias{scale_fill_material_c}
\title{Material design color palette}
\usage{
scale_color_material(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_material_d(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_material_c(
  palette = "contrast",
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_material(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_material_c(
  palette = "contrast",
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_material_d(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_fill_material(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_material_d(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_material_c(
  palette = NULL,
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)
}
\arguments{
\item{palette}{Character name of palette. Depending on the color scale, can
be one of \code{"full"}, \code{"ice"}, \code{"rainbow"}, \code{"complement"}, \code{"contrast"},
\code{"light"} (for dark themes), \code{"black_first"}, \code{full_original}, or
\code{black_first_original}. The latter three options are especially for the
Okabe-Ito color palette. The default is \code{NULL} and either \code{"contrast"} or
\code{"gradient"} is used (depending on whether \code{discrete} is \code{TRUE} or \code{FALSE}),
which are the two scale useful for discrete or gradient color scales,
respectively.}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{aesthetics}{A vector of names of the aesthetics that this scale
should be applied to (e.g., \code{c('color', 'fill')}).}

\item{...}{Additional arguments to pass to \code{\link[=colorRampPalette]{colorRampPalette()}}.}
}
\description{
The palette based on \href{https://materialui.co/}{material design colors}. Use
\code{scale_color_material_d()} for \emph{discrete} categories and
\code{scale_color_material_c()} for a \emph{continuous} scale, or use the \code{discrete}
argument in \code{scale_color_material()}.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_boxplot() +
  theme_modern() +
  scale_fill_material()

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_violin() +
  theme_modern() +
  scale_fill_material(palette = "ice")

ggplot(iris, aes(x = Petal.Length, y = Petal.Width, color = Sepal.Length)) +
  geom_point() +
  theme_modern() +
  scale_color_material(discrete = FALSE)
}
