% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_binomdensity.R
\name{geom_binomdensity}
\alias{geom_binomdensity}
\title{Add dot-densities for binary \code{y} variables}
\usage{
geom_binomdensity(data, x, y, scale = "auto", ...)
}
\arguments{
\item{data}{A dataframe.}

\item{x, y}{Characters corresponding to the x and y axis. Note that \code{y}
must be a variable with two unique values.}

\item{scale}{Character specifying method of scaling the dot-densities. Can
be: \code{'auto'} (corresponding to the square root of the proportion),
\code{'proportion'}, \code{'density'} or a custom list with values for each factor
level (see examples).}

\item{...}{Other arguments passed to \code{ggdist::geom_dots}.}
}
\description{
Add dot-densities for binary \code{y} variables
}
\examples{
library(ggplot2)
library(see)

data <- iris[1:100, ]

ggplot() +
  geom_binomdensity(data,
    x = "Sepal.Length",
    y = "Species",
    fill = "red",
    color = NA
  )

# Different scales
data[1:70, "Species"] <- "setosa" # Create unbalanced proportions

ggplot() +
  geom_binomdensity(data, x = "Sepal.Length", y = "Species", scale = "auto")
ggplot() +
  geom_binomdensity(data, x = "Sepal.Length", y = "Species", scale = "density")
ggplot() +
  geom_binomdensity(data, x = "Sepal.Length", y = "Species", scale = "proportion")
ggplot() +
  geom_binomdensity(data,
    x = "Sepal.Length", y = "Species",
    scale = list("setosa" = 0.4, "versicolor" = 0.6)
  )
}
