% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_bluebrown.R
\name{scale_color_bluebrown}
\alias{scale_color_bluebrown}
\alias{scale_color_bluebrown_d}
\alias{scale_color_bluebrown_c}
\alias{scale_colour_bluebrown}
\alias{scale_colour_bluebrown_c}
\alias{scale_colour_bluebrown_d}
\alias{scale_fill_bluebrown}
\alias{scale_fill_bluebrown_d}
\alias{scale_fill_bluebrown_c}
\title{Blue-brown color palette}
\usage{
scale_color_bluebrown(
  palette = "contrast",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_bluebrown_d(
  palette = "contrast",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_bluebrown_c(
  palette = "contrast",
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_bluebrown(
  palette = "contrast",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_bluebrown_c(
  palette = "contrast",
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_bluebrown_d(
  palette = "contrast",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_fill_bluebrown(
  palette = "contrast",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_bluebrown_d(
  palette = "contrast",
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_bluebrown_c(
  palette = "contrast",
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)
}
\arguments{
\item{palette}{Character name of palette. Depending on the color scale, can
be \code{"full"}, \code{"ice"}, \code{"rainbow"}, \code{"complement"},
\code{"contrast"}, \code{"light"} (for dark themes), or \code{"black_first"}.}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{aesthetics}{A vector of names of the aesthetics that this scale
should be applied to (e.g., \code{c('color', 'fill')}).}

\item{...}{Additional arguments to pass to \code{\link[=colorRampPalette]{colorRampPalette()}}.}
}
\description{
A blue-brown color palette. Use \code{scale_color_bluebrown_d()} for
\emph{discrete} categories and \code{scale_color_bluebrown_c()} for
a \emph{continuous} scale.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_boxplot() +
  theme_modern() +
  scale_fill_bluebrown_d()
}
