% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comb.indices.R
\name{comb.indices}
\alias{comb.indices}
\title{Construction of selection indices based on number of character grouping}
\usage{
comb.indices(ncomb, pmat, gmat, wmat, wcol = 1, GAY)
}
\arguments{
\item{ncomb}{Number of Characters/Traits group}

\item{pmat}{Phenotypic Variance-Covariance Matrix}

\item{gmat}{Genotypic Variance-Covariance Matrix}

\item{wmat}{Weight Matrix}

\item{wcol}{Weight column number incase more than one weights, by default its 1}

\item{GAY}{Genetic Advance of comparative Character/Trait i.e. Yield (Optional argument)}
}
\value{
Data frame of all possible selection indices
}
\description{
Construction of selection indices based on number of character grouping
}
\examples{
gmat<- gen.varcov(seldata[,3:9], seldata[,2], seldata[,1])
pmat<- phen.varcov(seldata[,3:9], seldata[,2], seldata[,1])
wmat<- weight.mat(weight)
comb.indices(ncomb = 1, pmat = pmat, gmat = gmat, wmat = wmat, wcol = 1, GAY = 1.075)

}
