% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semEff-fun.R
\name{semEff}
\alias{semEff}
\title{SEM Effects}
\usage{
semEff(
  sem,
  predictors = NULL,
  mediators = NULL,
  responses = NULL,
  use.raw = FALSE,
  ci.conf = 0.95,
  ci.type = "bca",
  digits = 3,
  bci.arg = NULL,
  ...
)
}
\arguments{
\item{sem}{A piecewise SEM, comprising a list of fitted model objects, or,
alternatively, of boot objects (class \code{"boot"}), containing
bootstrapped model effects.}

\item{predictors, mediators, responses}{Names of variables for/through which to
calculate effects. If \code{NULL} (default), all predictors, endogenous
predictors (mediators), and endogenous variables (responses) will be used.}

\item{use.raw}{Logical, whether to use 'raw' (unstandardised) effects for
all calculations (if present in \code{sem} object).}

\item{ci.conf}{A numeric value specifying the confidence level for confidence
intervals on effects.}

\item{ci.type}{The type of confidence interval to return (defaults to
\code{"bca"} - see Details). See \code{\link[boot]{boot.ci}} for further
specification details.}

\item{digits}{The number of significant digits to return for numeric values.}

\item{bci.arg}{A named list of any additional arguments to \code{boot.ci},
excepting argument \code{index}.}

\item{...}{Arguments to \code{\link[semEff]{bootEff}}.}
}
\value{
A list object of class \code{"semEff"}, comprising: \enumerate{\item
all effects \item all bootstrapped effects \item summary tables of effects
and confidence intervals}
}
\description{
Automatically calculate direct, indirect, total, and mediator
effects for endogenous (response) variables in a 'piecewise' structural
equation model (SEM).
}
\details{
The eponymous function of this package calculates all direct,
indirect, total, and mediator effects for endogenous variables in a
'piecewise' structural equation model (SEM), that is, one where parameter
estimation is local rather than global (Shipley 2000, 2009; Lefcheck 2016).
The SEM simply takes the form of a list of fitted models, or bootstrapped
estimates from such models, describing hypothesised causal pathways from
predictors to response ('endogenous') variables. These are either direct,
or operate indirectly via other response variables ('mediators'). This list
should represent a directed ('acyclic') causal model, which should be named
(exactly) for each response variable and ordered from 'upstream' or
'causal' variables through to 'downstream' (i.e. those at the end of the
pathway). If \code{sem} is a list of fitted models, effects will first be
bootstrapped using \code{bootEff} (this may take a while!).

Direct effects are calculated as fully standardised model coefficients for
each response variable, while indirect effects are the product of these
direct effects operating along causal pathways in the SEM. The total
effects of any given predictor on a response are then the sum of its direct
and (all) its indirect effects. 'Mediator' effects are also calculated, as
the sum of all indirect paths which operate through each individual
mediator - useful to assess the relative importance of different mediators
in affecting the response. All of these effect types are calculated
automatically for all (default) or a subset of predictors, mediators, or
response variables in the SEM.

Confidence intervals for effects are returned for each response, with
BC\emph{a} intervals calculated by default using bootstrapped estimates for
each effect type (MacKinnon \emph{et al.} 2004, Cheung 2009, Hayes &
Scharkow 2013). As indirect, total, and mediator effects are not directly
bootstrapped using the fitted models for response variables (i.e. via
\code{bootEff}), their equivalent 'bootstrapped' estimates are calculated
instead using each bootstrapped direct effect.

Correlated errors (and confidence intervals) are also returned if their
bootstrapped values are present in \code{sem}, or, if \code{sem} is a list
of fitted models, if specified to argument \code{cor.err} (see
\code{\link[semEff]{bootEff}}). These represent residual relationships
among response variables, unaccounted for by the SEM.

All effects and bootstrapped effects are returned in lists for each
response variable, with all except mediator effects also including the
model intercept(s) - required for prediction (this will be zero for
ordinary linear models with fully standardised effects).
}
\examples{
# SEM effects
(Shipley.SEM.Eff <- semEff(Shipley.SEM.Boot))

# Effects for selected variables
# semEff(Shipley.SEM.Boot, predictors = "lat")
# semEff(Shipley.SEM.Boot, mediators = "DD")
# semEff(Shipley.SEM.Boot, responses = "Live")

# Effects calculated using original SEM (models)
# (not typically recommended - better to use saved boot objects)
# system.time(
#  Shipley.SEM.Eff <- semEff(Shipley.SEM, R = 10000, seed = 53908,
#                            ran.eff = "site")
# )
}
\references{
Cheung, M. W. L. (2009). Comparison of methods for constructing
confidence intervals of standardized indirect effects. \emph{Behavior
Research Methods}, \strong{41}(2), 425-438. \url{https://doi.org/fnx7xk}

Hayes, A. F., & Scharkow, M. (2013). The Relative Trustworthiness of
Inferential Tests of the Indirect Effect in Statistical Mediation Analysis:
Does Method Really Matter? \emph{Psychological Science}, \strong{24}(10),
1918-1927. \url{https://doi.org/bbhr}

Lefcheck, J. S. (2016). piecewiseSEM: Piecewise structural equation
modelling in \code{R} for ecology, evolution, and systematics.
\emph{Methods in Ecology and Evolution}, \strong{7}(5), 573-579.
\url{https://doi.org/f8s8rb}

MacKinnon, D. P., Lockwood, C. M., & Williams, J. (2004). Confidence Limits
for the Indirect Effect: Distribution of the Product and Resampling
Methods. \emph{Multivariate Behavioral Research}, \strong{39}(1), 99.
\url{https://doi.org/chqcnx}

Shipley, B. (2000). A New Inferential Test for Path Models Based on
Directed Acyclic Graphs. \emph{Structural Equation Modeling: A
Multidisciplinary Journal}, \strong{7}(2), 206-218.
\url{https://doi.org/cqm32d}

Shipley, B. (2009). Confirmatory path analysis in a generalized multilevel
context. \emph{Ecology}, \strong{90}(2), 363-368.
\url{https://doi.org/bqd43d}
}
