% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdEff-fun.R
\name{xNam}
\alias{xNam}
\title{Get Model Term Names}
\usage{
xNam(mod, intercept = TRUE, aliased = TRUE, list = FALSE, env = parent.frame())
}
\arguments{
\item{mod}{A fitted model object, or a list or nested list of such objects.}

\item{intercept}{Logical, whether the intercept should be included.}

\item{aliased}{Logical, whether names of aliased terms should be included
(see Details).}

\item{list}{Logical, whether names should be returned as a list, with all
multi-coefficient terms grouped under their main term names.}

\item{env}{Environment in which to look for model data (used to construct the
model frame).}
}
\value{
A character vector or list/nested list of term names.
}
\description{
Extract term names from a fitted model object.
}
\details{
Extract term names from a fitted model. Names of terms for which
coefficients cannot be estimated are also included if \code{aliased = TRUE}
(default). These may be terms which are perfectly correlated with other
terms in the model, so that the model design matrix is rank deficient.
}
\examples{
# Term names from Shipley SEM
m <- Shipley.SEM
xNam(m)
xNam(m, intercept = FALSE)

# Model with different types of predictor (some multi-coefficient terms)
d <- data.frame(
  y = rnorm(100),
  x1 = rnorm(100),
  x2 = as.factor(rep(c("a", "b", "c", "d"), each = 25)),
  x3 = rep(1, 100)
)
m <- lm(y ~ poly(x1, 2) + x2 + x3, data = d)
xNam(m)
xNam(m, aliased = FALSE)  # drop term that cannot be estimated (x3)
xNam(m, aliased = FALSE, list = TRUE)  # names as list
}
