% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdEff-fun.R
\name{avgEst}
\alias{avgEst}
\title{Weighted Average of Model Estimates}
\usage{
avgEst(est, weights = "equal", est.names = NULL)
}
\arguments{
\item{est}{A list or nested list of numeric vectors, comprising the model
estimates. In the latter case, these should correspond to estimates for
candidate models for each of a set of different response variables.}

\item{weights}{An optional numeric vector of weights to use for model
averaging, or a named list of such vectors. The former should be supplied
when \code{est} is a list, and the latter when it is a nested list (with
matching list names). If \code{weights = "equal"} (default), a simple average is
calculated instead.}

\item{est.names}{An optional vector of names used to extract and/or sort
estimates from the output.}
}
\value{
A numeric vector of the model-averaged estimates, or a list of such
vectors.
}
\description{
Calculate a weighted average of model estimates (e.g. effects,
fitted values, residuals) for a set of models.
}
\details{
This function can be used to calculate a weighted average of model
estimates such as effects, fitted values, or residuals, where models are
typically competing candidate models fit to the same response variable.
Weights are typically a 'weight of evidence' type metric such as Akaike
model weights (Burnham & Anderson, 2002; Burnham et al., 2011), which can
be conveniently calculated in \emph{R} using packages such as
\href{https://cran.r-project.org/package=MuMIn}{MuMIn} or
\href{https://cran.r-project.org/package=AICcmodavg}{AICcmodavg}. However,
numeric weights of any sort can be used. If none are supplied, a simple
average is calculated instead.

Averaging is performed via the 'full'/'zero' rather than
'subset'/'conditional'/'natural' method, meaning that zero is substituted
for estimates for any 'missing' parameters (e.g. effects) prior to
calculations. This provides a form of shrinkage and thus reduces \href{https://stackoverflow.com/questions/53055050/predicted-values-with-mumin-throwing-error-when-full-false}{estimate bias}
(Burnham & Anderson, 2002; Grueber et al., 2011).
}
\examples{
# Model-averaged effects (coefficients)
m <- shipley.growth  # candidate models
e <- lapply(m, function(i) coef(summary(i))[, 1])
avgEst(e)

# Using weights
w <- runif(length(e), 0, 1)
avgEst(e, w)

# Model-averaged predictions
f <- lapply(m, predict)
head(avgEst(f, w))
}
\references{
Burnham, K. P., & Anderson, D. R. (2002). \emph{Model Selection and
Multimodel Inference: A Practical Information-Theoretic Approach} (2nd
ed.). Springer-Verlag. \url{https://link.springer.com/book/10.1007/b97636}

Burnham, K. P., Anderson, D. R., & Huyvaert, K. P. (2011). AIC model
selection and multimodel inference in behavioral ecology: some background,
observations, and comparisons. \emph{Behavioral Ecology and Sociobiology},
\emph{65}(1), 23-35. \doi{10/c4mrns}

Dormann, C. F., Calabrese, J. M., Guillera‐Arroita, G., Matechou, E., Bahn,
V., Bartoń, K., Beale, C. M., Ciuti, S., Elith, J., Gerstner, K., Guelat,
J., Keil, P., Lahoz‐Monfort, J. J., Pollock, L. J., Reineking, B., Roberts,
D. R., Schröder, B., Thuiller, W., Warton, D. I., … Hartig, F. (2018).
Model averaging in ecology: A review of Bayesian, information-theoretic,
and tactical approaches for predictive inference. \emph{Ecological Monographs},
\emph{88}(4), 485–504. \doi{10/gfgwrv}

Grueber, C. E., Nakagawa, S., Laws, R. J., & Jamieson, I. G. (2011).
Multimodel inference in ecology and evolution: challenges and solutions.
\emph{Journal of Evolutionary Biology}, \emph{24}(4), 699-711. \doi{10/b7b5d4}

Walker, J. A. (2019). Model-averaged regression coefficients have a
straightforward interpretation using causal conditioning. \emph{BioRxiv},
133785. \doi{10/c8zt}
}
