% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{semPower.getDf}
\alias{semPower.getDf}
\title{semPower.getDf}
\usage{
semPower.getDf(lavModel, nGroups = NULL, group.equal = NULL)
}
\arguments{
\item{lavModel}{the \code{lavaan} model string. Can also include (restrictions on) defined parameters.}

\item{nGroups}{for multigroup models: the number of groups.}

\item{group.equal}{for multigroup models: vector defining the type(s) of cross-group equality constraints following the \code{lavaan} conventions (\code{loadings}, \code{intercepts}, \code{means}, \code{residuals}, \code{residual.covariances}, \code{lv.variances}, \code{lv.covariances}, \code{regressions}).}
}
\value{
Returns the df of the model.
}
\description{
Determines the degrees of freedom of a given model provided as \code{lavaan} model string. This only returns the regular df and does not account for approaches using scaled df.
This requires the \code{lavaan} package.
}
\examples{
\dontrun{
lavModel <- '
f1 =~ x1 + x2 + x3 + x4
f2 =~ x5 + x6 + x7 + x8
f3 =~ y1 + y2 + y3
f3 ~ f1 + f2
'
semPower.getDf(lavModel)

# multigroup version
semPower.getDf(lavModel, nGroups = 3)  
semPower.getDf(lavModel, nGroups = 3, group.equal = c('loadings'))
semPower.getDf(lavModel, nGroups = 3, group.equal = c('loadings', 'intercepts'))
}
}
