% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pa_dat2}
\alias{pa_dat2}
\title{Sample Data: A Path Model with an Influential Case}
\format{
A data frame with 100 rows
and 5 variables:
\describe{
\item{case_id}{Case ID. Character.}
\item{iv1}{Predictor. Numeric.}
\item{iv2}{Predictor. Numeric.}
\item{m1}{Mediator. Numeric.}
\item{dv}{Outcome variable. Numeric.}
}
}
\usage{
pa_dat2
}
\description{
A four-variable dataset with 100 cases, with
one influential case.
}
\examples{
library(lavaan)
data(pa_dat2)
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
fit <- sem(mod, pa_dat2)
summary(fit)
inf_out <- influence_stat(fit)
gcd_plot(inf_out)
}
\keyword{datasets}
