
# skip long running tests on CRAN
skip_on_cran()

# OpenMx model with definition variables
#



N <- 1000

lat <- rnorm(N)
x1 <- lat+rnorm(N,0,0.1)
x2 <- lat+rnorm(N,0,0.1)
x3 <- lat+rnorm(N,0,0.1)
x4 <- rnorm(N,0, 1)
grp <- sample(c(0,1),N,TRUE)

df <- data.frame(x1,x2,x3,x4, grp)

#
# This model specification was automatically generated by Onyx
# 
require("OpenMx");
manifests<-c("x1","x2","x3")
latents<-c("x4")
model <- mxModel("Unnamed_Model", 
                 type="RAM",
                 manifestVars = manifests,
                 latentVars = latents,
                 mxPath(from="x4",to=c("x1","x2","x3"), free=c(FALSE,FALSE,FALSE), value=c(1.0,1.0,1.0) , arrows=1, label=c("data.x4","x4__x2","x4__x3") ),
                 mxPath(from="x1",to=c("x1"), free=c(TRUE), value=c(1.0) , arrows=2, label=c("VAR_x1") ),
                 mxPath(from="x2",to=c("x2"), free=c(TRUE), value=c(1.0) , arrows=2, label=c("VAR_x2") ),
                 mxPath(from="x3",to=c("x3"), free=c(TRUE), value=c(1.0) , arrows=2, label=c("VAR_x3") ),
                 mxPath(from="x4",to=c("x4"), free=c(TRUE), value=c(1.0) , arrows=2, label=c("VAR_x4") ),
                 mxPath(from="one",to=c("x1","x2","x3"), free=F, value=0, arrows=1),
                 mxData(df, type = "raw")
);

result <- mxRun(model)
summary(result)



tree<-semtree(model, df)
