% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safelist-class.R
\docType{class}
\name{safelist-class}
\alias{safelist-class}
\alias{safelist}
\title{Format for SAFE archive lists}
\description{
\code{safelist} is a format thought to manage lists of SAFE
Sentinel.2 archives.
It is a named character in which names are SAFE codes
(e.g. \code{S2A_MSIL2A_20170507T102031_N0205_R065_T32TNR_20170507T102319.SAFE}),
and values are URLs used to retrieve them from ESA API Hub (e.g.
\verb{https://scihub.copernicus.eu/apihub/odata/v1/Products('a4a026c0-db7b-4ba8-9b09-53027ab0d7ab')/$value}).
Some attributes may be included, basically information retrieved by
function \link{s2_list} containing product metadata.
Moreover, the attribute \code{online} (retrieved by function \link{safe_is_online}
may contain logical values (TRUE for products available for download,
FALSE for products stored in the Long Term Archive).

The class can be generated as an output of function \link{s2_list}, or converting
named characters (with the same structures), data.frames or data.tables
(including the columns \code{name} and \code{url}) using \link{as} (see examples).
Objects of class \code{safelist} can be converted to named character, data.frames
or data.tables (see examples). The conversion to data.frame / data.table is
useful for reading hidden attributes.
}
\note{
License: GPL 3.0
}
\examples{
\donttest{
pos <- sf::st_sfc(sf::st_point(c(9.85,45.81)), crs = 4326)
time_window <- as.Date(c("2017-05-01", "2017-05-31"))

## Create an object of class safelist
list_safe <- s2_list(spatial_extent = pos, time_interval = time_window)
list_safe
class(list_safe)
attr(list_safe, "sensing_datetime") # extract an hidden attribute from a safelist

## Convert to other classes
(s2_char <- as.character(list_safe)) # convert to a simple named character
(s2_df <- as.data.frame(list_safe)) # convert to a data.frame
library(data.table)
(s2_dt <- as.data.table(list_safe)) # convert to a data.table
library(sf)
(s2_sf <- st_as_sf(list_safe)) # convert to sf

## Convert from other classes
as(s2_char, "safelist") # this causes the loss of hidden attributes
as(s2_df, "safelist") # this (and followings) maintain attributes as columns
as(s2_dt, "safelist")
as(s2_sf, "safelist")
}
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
