% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovb_plots.R
\name{ovb_contour_plot}
\alias{ovb_contour_plot}
\alias{ovb_contour_plot.lm}
\alias{ovb_contour_plot.formula}
\alias{ovb_contour_plot.numeric}
\title{Contour plots of omitted variable bias}
\usage{
ovb_contour_plot(...)

\method{ovb_contour_plot}{lm}(model, treatment,
  benchmark_covariates = NULL, kd = 1, ky = kd, r2dz.x = NULL,
  r2yz.dx = r2dz.x, bound_label = NULL,
  sensitivity.of = c("estimate", "t-value"), reduce = TRUE,
  estimate.threshold = 0, t.threshold = 2, lim = max(c(0.4, r2dz.x,
  r2yz.dx)), nlevels = 20, col.contour = "grey40",
  col.thr.line = "red", label.text = TRUE, label.bump.x = 0.02,
  label.bump.y = 0.02, ...)

\method{ovb_contour_plot}{formula}(formula, data, treatment,
  benchmark_covariates = NULL, kd = 1, ky = kd, r2dz.x = NULL,
  r2yz.dx = r2dz.x, bound_label = NULL,
  sensitivity.of = c("estimate", "t-value"), reduce = TRUE,
  estimate.threshold = 0, t.threshold = 2, lim = max(c(0.4, r2dz.x,
  r2yz.dx)), nlevels = 20, col.contour = "grey40",
  col.thr.line = "red", label.text = TRUE, ...)

\method{ovb_contour_plot}{numeric}(estimate, se, dof, r2dz.x = NULL,
  r2yz.dx = r2dz.x, bound_label = "", sensitivity.of = c("estimate",
  "t-value"), reduce = TRUE, estimate.threshold = 0, t.threshold = 2,
  lim = max(c(0.4, r2dz.x + 0.1, r2yz.dx + 0.1)), nlevels = 20,
  col.contour = "black", col.thr.line = "red", label.text = TRUE,
  cex.label.text = 1, label.bump.x = 0.02, label.bump.y = 0.02, ...)
}
\arguments{
\item{...}{arguments passed to other methods. First argument should either be an \code{\link{lm}} model with the
outcome regression, a \code{\link{formula}} describing the model along
with the \code{\link{data.frame}} containing the variables of the model,
or a numeric vector with the coefficient estimate.}

\item{model}{An \code{lm} object with the outcome regression.}

\item{treatment}{A character vector with the name of the treatment variable
of the model.}

\item{benchmark_covariates}{a character vector of the names of covariates that will be used to bound the plausible strength
of the unobserved confounders.}

\item{kd}{numeric vector. Parameterizes how many times stronger the confounder is related to the treatment in comparison to the observed benchmark covariate.
Default value is \code{1} (confounder is as strong as benchmark covariate).}

\item{ky}{numeric vector. Parameterizes how many times stronger the confounder is related to the outcome in comparison to the observed benchmark covariate.
Default value is the same as \code{kd}.}

\item{r2dz.x}{Hypothetical partial R2 of unobserved confounder
Z with treatment D, given covariates X.}

\item{r2yz.dx}{Hypothetical partial R2 of unobserved confounder Z
with outcome Y, given covariates X and treatment D.}

\item{bound_label}{label to bounds provided manually in \code{r2dz.x} and \code{r2yz.dx}.}

\item{sensitivity.of}{should the contour plot show adjusted estimates (\code{"estimate"})
or adjusted t-values (\code{"t-value"})?}

\item{reduce}{Should the bias adjustment reduce or increase the
absolute value of the estimated coefficient? Default is \code{TRUE}.}

\item{estimate.threshold}{critical threshold for the point estimate.}

\item{t.threshold}{critical threshold for the t-value.}

\item{lim}{sets limit of the plot.}

\item{nlevels}{number of levels for the contour plot.}

\item{col.contour}{color of contour lines.}

\item{col.thr.line}{color of threshold contour line.}

\item{label.text}{should label texts be plotted? Default is \code{TRUE}.}

\item{label.bump.x}{bump on the x coordinate of label text.}

\item{label.bump.y}{bump on the y coordinate of label text.}

\item{formula}{an object of the class \code{\link{formula}}: a symbolic description of the model to be fitted.}

\item{data}{data needed only when you pass a formula as first parameter. An object of the class \code{\link{data.frame}} containing the variables used in the analysis.}

\item{estimate}{Coefficient estimate.}

\item{se}{Standard error of the coefficient estimate.}

\item{dof}{Residual degrees of freedom of the regression.}

\item{cex.label.text}{size of the label text.}
}
\value{
The function returns invisibly the data used for the contour plot (contour grid and bounds).
}
\description{
Contour plots of omitted variable bias for sensitivity analysis. The main inputs are an \code{\link{lm}} model, the treatment variable
and the covariates used for benchmarking the strength of unobserved confounding.

The horizontal axis of the plot shows hypothetical values of the partial R2 of the unobserved confounder(s) with the treatment.
 The vertical axis shows hypothetical values of the partial R2 of the unobserved confounder(s) with the outcome.
 The contour levels represent the adjusted estimates (or t-values) of the treatment effect.
 The reference points are the bounds on the partial R2 of the unobserved confounder if it were \code{k} times ``as strong'' as the observed covariate used for benchmarking (see arguments \code{kd} and \code{ky}).
 The dotted red line show the chosen critical threshold (for instance, zero): confounders with such strength (or stronger) are sufficient to invalidate the research conclusions.
 All results are exact for single confounders and conservative for multiple/nonlinear confounders.

 See Cinelli and Hazlett (2018) for details.
}
\examples{

# runs regression model
model <- lm(peacefactor ~ directlyharmed + age + farmer_dar + herder_dar +
                         pastvoted + hhsize_darfur + female + village,
                         data = darfur)
# contour plot
ovb_contour_plot(model, treatment = "directlyharmed",
                        benchmark_covariates = "female",
                        kd = 1:2)

}
\references{
Cinelli, C. and Hazlett, C. "Making Sense of Sensitivity: Extending Omitted Variable Bias." (2018).
}
