% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol_indices.R
\name{sobol_indices}
\alias{sobol_indices}
\title{Computation of first, second, third and total-order Sobol' indices}
\usage{
sobol_indices(Y, params, type = "jansen", R, n, parallel = "no",
  ncpus = 1, second = FALSE, third = FALSE)
}
\arguments{
\item{Y}{Numeric vector, model output.}

\item{params}{Vector with the name of the model inputs.}

\item{type}{Estimator to use: \code{type = "saltelli"} uses
the \insertCite{Saltelli2010a;textual}{sensobol} estimator; \code{type = "jansen"}
uses the \insertCite{Jansen1999;textual}{sensobol} estimator. Default is \code{type = "jansen"}.}

\item{R}{Integer, number of bootstrap replicas.}

\item{n}{Integer, sample size of the sample matrix.}

\item{parallel}{The type of parallel operation to be used (if any).
If missing, the default is taken from the option "boot.parallel"
(and if that is not set, "no"). For more information, check the
\code{parallel} option in the \code{boot} function of the \code{\link{boot}} package.}

\item{ncpus}{Integer: number of processes to be used in parallel operation:
typically one would chose this to the number of available CPUs.
Check the \code{ncpus} option in the \code{boot} function of the \code{\link{boot}} package.}

\item{second}{Logical. if \code{second = TRUE}, it computes
second-order Sobol' indices.}

\item{third}{Logical. if \code{third = TRUE}, it computes
third-order Sobol' indices.}
}
\value{
A data.table object. It includes a column with the results of the bootstrap.
}
\description{
It computes and bootstraps up to third-order Sobol' indices
using either the \insertCite{Saltelli2010a;textual}{sensobol} or the
\insertCite{Jansen1999;textual}{sensobol}
estimator.
}
\examples{
# Define settings:
n <- 1000; k <- 8; R <- 100
# Design the sample matrix:
A <- sobol_matrices(n = n, k = k, second = TRUE, third = TRUE)
# Compute the model output:
Y <- sobol_Fun(A)
# Compute the Sobol' indices:
\donttest{sens <- sobol_indices(Y = Y, params = colnames(data.frame(A)),
R = R, n = n, parallel = "no", ncpus = 1, second = TRUE, third = TRUE)}
}
\references{
\insertAllCited{}
}
\seealso{
Check the function \code{\link{boot}} for further details on the bootstrapping
and the components available within the class \code{boot}.
}
