#' @description
#' This package uses Google's Universal Sentence Encoder, simplifies all the
#' difficulties, and turns it into a sentiment analysis package.
#'
#' Main Benefits:
#' \itemize{
#'   \item{Tolerates spelling mistakes}
#'   \item{Not dependent on exactly matching a fixed dictionary}
#'   \item{Requires less pre-processing}
#'   \item{More powerful than dictionary-based methods}
#' }
#'
#' Main Drawbacks:
#' \itemize{
#'   \item{Requires a lot of RAM}
#'   \item{Can be slow on larger datasets (unless using GPU)}
#' }
#'
#' Effectivelly, if you have a reasonably powerful computer, you can use
#' sentiment.ai as a more flexible, powerful, and modern approach to sentiment
#' analysis.
"_PACKAGE"
