% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomodel.R
\name{get_loss_data}
\alias{get_loss_data}
\title{Retrieve loss data from a selection of models}
\usage{
get_loss_data(models, loss = c("DA", "error", "errorSq", "AD",
  "accuracy"))
}
\arguments{
\item{models}{a named \code{list} of \code{sentomodeliter} objects. All models should be of the same family, being
either \code{"gaussian"}, \code{"binomial"} or \code{"multinomial"}, and have performance data of the same dimensions.}

\item{loss}{a single \code{character} vector, either \code{"DA"} (directional \emph{in}accuracy), \code{"error"}
(prediction minus realized response variable), \code{"errorSq"} (squared errors), \code{"AD"} (absolute errors) or
\code{"accuracy"} (\emph{in}accurate class predictions). This argument defines on what basis the model confidence set
is calculated. The first four options are available for \code{"gaussian"} models, the last option applies only to
\code{"binomial"} and \code{"multinomial"} models.}
}
\value{
A \code{matrix} of loss data.
}
\description{
Structures specific performance data for a set of different \code{sentomodeliter} objects as loss data.
Can then be used, for instance, as an input to create a model confidence set (Hansen, Lunde and Nason, 2011) with
the \pkg{MCS} package.
}
\examples{
\dontrun{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")
data("epu", package = "sentometrics")

set.seed(505)

# construct two sentomeasures objects
corpusAll <- sento_corpus(corpusdf = usnews)
corpus <- quanteda::corpus_subset(corpusAll, date >= "1997-01-01" & date < "2014-10-01")
l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])

ctrA <- ctr_agg(howWithin = "proportionalPol", howDocs = "proportional",
                howTime = c("equal_weight", "linear"), by = "month", lag = 3)
sentMeas <- sento_measures(corpus, l, ctrA)

# prepare y and other x variables
y <- epu[epu$date \%in\% get_dates(sentMeas), "index"]
length(y) == nobs(sentMeas1) # TRUE
x <- data.frame(runif(length(y)), rnorm(length(y))) # two other (random) x variables
colnames(x) <- c("x1", "x2")

# estimate different type of regressions
ctrM <- ctr_model(model = "gaussian", type = "AIC", do.iter = TRUE,
                 h = 0, nSample = 120, start = 50)
out1 <- sento_model(sentMeas, y, x = x, ctr = ctrM)
out2 <- sento_model(sentMeas, y, x = NULL, ctr = ctrM)
out3 <- sento_model(measures_select(sentMeas, "linear"), y, x = x, ctr = ctrM)
out4 <- sento_model(measures_select(sentMeas, "linear"), y, x = NULL, ctr = ctrM)

lossData <- get_loss_data(models = list(m1 = out1, m2 = out2, m3 = out3, m4 = out4),
                          loss = "errorSq")

mcs <- MCS::MCSprocedure(lossData)}

}
\references{
Hansen, Lunde and Nason (2011). ``The model confidence set''. \emph{Econometrica 79, 453-497},
\url{https://doi.org/10.3982/ECTA5771}.
}
\seealso{
\code{\link{sento_model}}, \code{\link[MCS]{MCSprocedure}}
}
\author{
Samuel Borms
}
