% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_group_summaries.R
\name{add_group_summaries}
\alias{add_group_summaries}
\title{Simulate the group_by/mutate pattern with an explicit summarize and join.}
\usage{
add_group_summaries(d, groupingVars, ..., arrangeTerms = NULL)
}
\arguments{
\item{d}{data.frame}

\item{groupingVars}{character vector of column names to group by.}

\item{...}{list of dplyr::mutate() expressions.}

\item{arrangeTerms}{character vector of column expressions to group by.}
}
\value{
d with grouped summaries added as extra columns
}
\description{
Group a data frame by the groupingVars and compute user summaries on
this data frame (user summaries specified in ...), then join these new
columns back into the original data and return to the user.
Author: John Mount, Win-Vector LLC.
}
\examples{

add_group_summaries(datasets::mtcars,
                    c("cyl", "gear"),
                    group_mean_mpg = mean(mpg),
                    group_mean_disp = mean(disp)) \%>\%
  head()

}
