% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_rank_indices.R
\name{add_rank_indices}
\alias{add_rank_indices}
\title{Arrange a data frame and rank indexes.}
\usage{
add_rank_indices(.data, ..., arrangeTerms = NULL, orderColumn)
}
\arguments{
\item{.data}{data.frame}

\item{...}{force later arguments to bind by name.}

\item{arrangeTerms}{character vector of column expressions to arrange by.}

\item{orderColumn}{character name of column to add in-group order marks to.}
}
\value{
.data with order indices added (no ties).
}
\description{
Arrange a data frame and rank indexes.
}
\examples{


datasets::mtcars \%>\%
  # tibble::rownames_to_column() not currently re-exported by dplyr
  { mutate(., CarName = rownames(.) ) } \%>\%
  select_se(c('CarName', 'hp', 'wt')) \%>\%
  add_rank_indices(arrangeTerms = c('desc(hp)', 'wt'),
                   orderColumn = 'rankID') \%>\%
  arrange_se(c('rankID'))


}
