% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theo.R
\name{seqgen_base}
\alias{seqgen_base}
\title{Simulate RNA-seq data from the (unrealistic) theoretical model.}
\usage{
seqgen_base(designmat, coefmat, dispvec)
}
\arguments{
\item{designmat}{A numeric design matrix. The rows index the samples
and the columns index the variables.}

\item{coefmat}{A numeric matrix of coefficients. The rows index the
genes and the columns index the variables.}

\item{dispvec}{A vector of negative binomial dispersion parameters.
Element i is the dispersion for gene i.}
}
\value{
A matrix of RNA-seq counts. The rows index the genes and the columns
    index the samples.
}
\description{
The main difference between \code{seqgen_base} and \code{seqgen_diff}
is the output format.
}
\details{
You should be using \code{\link{thin_base}} instead of this. If you must
simulate from the theoretical model, I would recommend trying out
the powsimR package (\url{https://github.com/bvieth/powsimR}) from
Vieth et al. (2017).
}
\references{
\itemize{
  \item{Vieth, Beate, Christoph Ziegenhain, Swati Parekh, Wolfgang Enard, and Ines Hellmann. "powsimR: power analysis for bulk and single cell RNA-seq experiments." Bioinformatics 33, no. 21 (2017): 3486-3488.}
}
}
\author{
David Gerard
}
