% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theo.R
\name{seqgen_2group}
\alias{seqgen_2group}
\title{Theoretical sequence simulation in the two-group model.}
\usage{
seqgen_2group(ngene, nsamp, dispvec = rep(0.1, times = ngene),
  prop_null = 1, signal_fun = stats::rnorm, signal_params = list(mean
  = 0, sd = 1), intercept_fun = stats::rnorm,
  intercept_params = list(mean = 4, sd = 2), libvec = rep(1, times =
  nsamp), group_prop = 0.5, design_sv = NULL, coef_sv = NULL)
}
\arguments{
\item{ngene}{The number of genes.}

\item{nsamp}{The number of samples.}

\item{dispvec}{A numeric vector of dispersions.}

\item{prop_null}{The proportion of genes that are null.}

\item{signal_fun}{The signal function for the non-null genes.
A function that takes at least the argument \code{n}
and returns \code{n} draws. Additional parameters may be passed
through \code{signal_params}.}

\item{signal_params}{Additional arguments to be passed to \code{signal_fun}.}

\item{intercept_fun}{The function for the intercept coefficients. A function
that takes at least the argument \code{n} and returns \code{n} draws.
Additional parameters may be passed through \code{intercept_params}.}

\item{intercept_params}{Additional arguments to be passed to
\code{intercept_fun}.}

\item{libvec}{A vector of library size multiplicative factors (not
on the log2 scale).}

\item{group_prop}{The proportion of samples to be placed in group 1.}

\item{design_sv}{Optional numeric design matrix of surrogate variables. The
rows index the samples and the columns index the surrogate variables.}

\item{coef_sv}{Optional numeric matrix of coefficients of the surrogate
variables. The rows index the genes and the columns index the surrogate
variables.}
}
\value{
A list object with some or all of the following elements:
\describe{
 \item{\code{mat}}{A matrix of RNA-seq counts. The rows index the genes and
     the columns index the samples.}
 \item{\code{designmat}}{The user-provided \code{designmat}.}
 \item{\code{coefmat}}{The user-provided \code{coefmat}.}
 \item{\code{sv}}{The user-provided \code{design_sv}.}
 \item{\code{coef_sv}}{The user-provided \code{coef_sv}.}
}
}
\description{
Generate a matrix of RNA-seq counts from a theoretical negative-binomial
model. This is in the special case of the two-group model.
}
\details{
You should be using \code{\link{thin_2group}} instead of this. If you must
simulate from the theoretical model, I would recommend trying out
the powsimR package (\url{https://github.com/bvieth/powsimR}) from
Vieth et al. (2017).
}
\references{
\itemize{
  \item{Vieth, Beate, Christoph Ziegenhain, Swati Parekh, Wolfgang Enard, and Ines Hellmann. "powsimR: power analysis for bulk and single cell RNA-seq experiments." Bioinformatics 33, no. 21 (2017): 3486-3488.}
}
}
\seealso{
\describe{
  \item{\code{\link[DESeq2]{makeExampleDESeqDataSet}}}{For a very similar
      function from the DESeq2 package.}
  \item{\code{\link{seqgen_diff}}}{For the underlying sequence simulation
      function.}
}
}
\author{
David Gerard
}
