% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{seqmissfplot}
\alias{seqmissfplot}
\title{Plot the most common patterns of missing data.}
\usage{
seqmissfplot(data, var = NULL, with.complete = TRUE, ...)
}
\arguments{
\item{data}{a data.frame where missing data are coded as \code{NA} or 
a state sequence object built with \link[TraMineR]{seqdef} function}

\item{var}{the list of columns containing the trajectories. 
Default is NULL, i.e. all the columns.}

\item{with.complete}{a logical stating if complete trajectories 
should be included or not in the plot}

\item{...}{parameters to be passed to the \link[TraMineR]{seqfplot} function}
}
\description{
Plot function that renders the most frequent patterns of missing data. This
function is based on the \link[TraMineR]{seqfplot} function.
}
\details{
This plot function is based on the \link[TraMineR]{seqfplot} function. 
To see which arguments can be changed, see the \link[TraMineR]{seqfplot} 
help. In particular, the number of most frequent 
patterns to be plotted can be changed with the argument \code{idxs}. By 
default, the 10 most frequent patterns are plotted.
}
\examples{
# Plot the 10 most common patterns of missing data

seqmissfplot(gameadd, var=1:4)

# Plot the 10 most common patterns of missing data discarding 
# complete trajectories

seqmissfplot(gameadd, var=1:4, with.missing = FALSE)

# Plot only the 5 most common patterns of missing data discarding 
# complete trajectories

seqmissfplot(gameadd, var=1:4, with.missing = FALSE, idxs = 1:5)

}
\author{
Kevin Emery
}
