% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequoia_F90wrappers.R
\name{SeqDup}
\alias{SeqDup}
\title{Check data for duplicates.}
\usage{
SeqDup(Specs = NULL, GenoM = NULL, LhIN = NULL, quiet = FALSE)
}
\arguments{
\item{Specs}{The 1-row dataframe with parameter values}

\item{GenoM}{matrix with genotype data, size nInd x nSnp}

\item{LhIN}{life history data}

\item{quiet}{suppress messages}
}
\value{
A list with one or more of the following elements:
\item{DupGenoID}{Dataframe, rownumbers of duplicated IDs in genotype data.
  Please do remove or relabel these to avoid downstream confusion.}
\item{DupGenotype}{Dataframe, duplicated genotypes (with or without
  identical IDs). The specified number of maximum mismatches is allowed,
  and this dataframe may include pairs of closely related individuals.}
\item{DupLifeHistID}{Dataframe, rownumbers of duplicated IDs in life
  history data}
\item{NoLH}{Vector, IDs (in genotype data) for which no life history data is
 provided}

dataframe with the numbers of duplicated genotypes, duplicated IDs in the
genotype data, number of duplicated IDs in the life history data, and number
 of individuals with unknown sex.
}
\description{
Check the genotype and life history data for duplicate IDs (not permitted)
and duplicated genotypes (not advised), and count how many individuals in
the genotype data are not included in the life history data (permitted). The
order of IDs in the genotype and life history data is not required to be
identical.
}

