% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotAgePrior.R
\name{PlotAgePrior}
\alias{PlotAgePrior}
\title{Plot Age Priors}
\usage{
PlotAgePrior(AP = NULL, legend = TRUE)
}
\arguments{
\item{AP}{matrix with age priors (\eqn{P(A|R)/P(A)}) with age differences in
rows and relationships in columns; by default M: maternal parent (mother),
P: paternal parent (father), FS: full siblings, MS: maternal siblings (full
+ half), PS: paternal siblings.}

\item{legend}{if \code{TRUE}, a new plotting window is started and
\code{\link{layout}} is used to plot a legend next to the main plot. Set to
\code{FALSE} if you want to add it as panel to an existing plot (e.g. with
\code{par(mfcol=c(2,2))}).}
}
\value{
A heatmap.
}
\description{
Visualise the age-difference based prior probability ratios as a
  heatmap.
}
\examples{
data(SeqOUT_griffin, package="sequoia")
PlotAgePrior(SeqOUT_griffin$AgePriors)
PlotAgePrior(SeqOUT_griffin$AgePriorExtra)

}
\seealso{
\code{\link{MakeAgePrior}}, \code{\link{SummarySeq}}.
}
