% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lle.R
\name{lle}
\alias{lle}
\alias{LLE}
\title{Locally Linear Embedding (LLE)}
\usage{
lle(x, m, k, reg = 2)
}
\arguments{
\item{x}{a matrix.}

\item{m}{dimensions of the desired embedding.}

\item{k}{number of neighbors.}

\item{reg}{regularization method. 1, 2 and 3, by default 2. See details.}
}
\value{
a matrix of vector with the embedding.
}
\description{
Performs the non linear dimensionality reduction method locally linear embedding
proposed in Roweis and Saul (2000).
}
\details{
LLE tries to find a lower-dimensional projection which preserves distances
within local neighborhoods. This is done by (1) find for each object the
k nearest neighbors, (2) construct the LLE weight matrix
which represents each point as a linear combination of its neighborhood, and
(2) perform partial eigenvalue decomposition to find the embedding.

The \code{reg} parameter allows the decision between different regularization methods.
As one step of the LLE algorithm, the inverse of the Gram-matrix \eqn{G\in R^{kxk}}
has to be calculated. The rank of \eqn{G} equals \eqn{m} which is mostly smaller
than \eqn{k} - this is why a regularization \eqn{G^{(i)}+r\cdot I} should be performed.
The calculation of regularization parameter \eqn{r} can be done using different methods:
\itemize{
\item \code{reg = 1}: standardized sum of eigenvalues of \eqn{G} (Roweis and Saul; 2000)
\item \code{reg = 2} (default): trace of Gram-matrix divided by \eqn{k} (Grilli, 2007)
\item \code{reg = 3}: constant value 3*10e-3
}
}
\examples{
data(iris)
x <- iris[, -5]

# project iris on 2 dimensions
conf <- lle(x, m = 2, k = 30)
conf

plot(conf, col = iris[, 5])

# project iris onto a single dimension
conf <- lle(x, m = 1, k = 30)
conf

plot_config(conf, col = iris[, 5], labels = FALSE)
}
\references{
Roweis, Sam T. and Saul, Lawrence K. (2000), Nonlinear Dimensionality
Reduction by Locally Linear Embedding,
\emph{Science,} \strong{290}(5500), 2323--2326. \doi{10.1126/science.290.5500.2323}

Grilli, Elisa (2007) Automated Local Linear Embedding with an application
to microarray data, Dissertation thesis, University of Bologna.
\doi{10.6092/unibo/amsdottorato/380}
}
\author{
Michael Hahsler (based on code by Holger Diedrich and Markus Abel)
}
\keyword{cluster}
\keyword{manip}
