% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-ratelimit.R
\name{Rate}
\alias{Rate}
\title{R6 Class Representing a Rate Limit for a user}
\description{
Rate object containing information about user's rate limit.
}
\details{
This is main object for Rate Limit.
}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{Rate}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{rate}}{A list containing the information about user's current rate
limit. It consists of the following fields:
\itemize{
\item \code{limit} Indicates how many requests can be made in five
minutes.
\item \code{remaining} Indicates how many requests remain.
\item \code{reset} Indicates the time when the request rate limit will
be reset.
}}

\item{\code{instance}}{A list containing the information about user's current
instance limit. It consists of the following fields:
\itemize{
\item \code{limit} Indicates the total number of instances available
to the user. For the first few months, instance limits are
unlimited. This is indicated by a special limit of -1.
Correspondingly, the remaining value is high.
\item \code{remaining} Indicates the number of the instances that are
available at the moment. For the first few months, instance limits
are unlimited. This is indicated by a high remaining value.
Correspondingly, the limit is set to a special value of -1.
}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Rate-new}{\code{Rate$new()}}
\item \href{#method-Rate-print}{\code{Rate$print()}}
\item \href{#method-Rate-clone}{\code{Rate$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sevenbridges2" data-topic="Item" data-id="reload"><a href='../../sevenbridges2/html/Item.html#method-Item-reload'><code>sevenbridges2::Item$reload()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rate-new"></a>}}
\if{latex}{\out{\hypertarget{method-Rate-new}{}}}
\subsection{Method \code{new()}}{
Create a new Rate limit object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rate$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing Rate limit object info.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rate-print"></a>}}
\if{latex}{\out{\hypertarget{method-Rate-print}{}}}
\subsection{Method \code{print()}}{
Print rate limit information as a bullet list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rate$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Rate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
