% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geohash.R
\name{st_geohash}
\alias{st_geohash}
\title{compute geohash from (average) coordinates (requires lwgeom)}
\usage{
st_geohash(x, precision = 0)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{precision}{integer; precision (length) of geohash returned; when omitted, precision 10 is taken.}
}
\value{
character vector with geohashes
}
\description{
compute geohash from (average) coordinates (requires lwgeom)
}
\details{
see \url{http://geohash.org/} or \url{https://en.wikipedia.org/wiki/Geohash}.
in case a geometry contains more than one point, the geohash for the average of the points in the geometry is returned.
}
\examples{
if (!is.na(sf_extSoftVersion()["lwgeom"])) {
 st_geohash(st_sfc(st_point(c(1.5,3.5)), st_point(c(0,90))), 2)
 st_geohash(st_sfc(st_point(c(1.5,3.5)), st_point(c(0,90))), 10)
}
}
