% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-gini.R
\name{spatial_gini}
\alias{spatial_gini}
\title{Spatial Gini Index}
\usage{
spatial_gini(x, nb)
}
\arguments{
\item{x}{a numeric vector without missing values}

\item{nb}{a neighbor list, for example created with \code{\link[=st_contiguity]{st_contiguity()}}}
}
\value{
A data frame with columns:
\itemize{
\item \code{G}: the Gini index
\item \code{NBG}: the neighbor composition of the Gini coefficient
\item \code{NG}: the non-neighbor composition of the Gini coefficient
\item \code{SG}: the Spatial Gini which is equal to \eqn{NG * \frac{1}{G}}
}
}
\description{
Calculates the spatial Gini index for a given numeric vector and neighbor list.
Based on the formula provided Rey and Smith (2013).
}
\details{
The Gini index is a global measure of inequality based on the Lorenz curve. It ranges between 0 and 1 where 0 is perfect equality and 1 is perfect inequality.

The spatial Gini index decomposes the Gini coefficient based on spatial neighbors.
}
\examples{
nb <- st_contiguity(guerry)
x <- guerry$wealth
spatial_gini(x, nb)

}
\references{
\doi{http://dx.doi.org/10.1007/s12076-012-0086-z}
}
