% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb-block-contiguity.R
\name{st_block_nb}
\alias{st_block_nb}
\title{Create Block Contiguity for Spatial Regimes}
\usage{
st_block_nb(regime, id = 1:length(regime), diag = FALSE)
}
\arguments{
\item{regime}{a column identifying which spatial regime each element of \code{id} belongs}

\item{id}{a column identifying unique observations}

\item{diag}{default \code{FALSE}. If \code{TRUE}, includes diagonal element / the self.}
}
\value{
An object of class \code{nb}. When \code{diag = TRUE} the attribute \code{self.included = TRUE}.
}
\description{
libpysal write that "block contiguity structures are relevant when defining neighbor relations based on membership in a regime. For example, all counties belonging to the same state could be defined as neighbors, in an analysis of all counties in the US."

Source: \href{https://pysal.org/libpysal/generated/libpysal.weights.block_weights.html}{libpysal}
}
\examples{
id <- guerry$code_dept
regime <- guerry$region
st_block_nb(regime, id)
}
