% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sftrack.R
\name{as_sftrack}
\alias{as_sftrack}
\alias{as_sftrack.data.frame}
\alias{as_sftrack.sftraj}
\alias{as_sftrack.ltraj}
\alias{as_sftrack.sf}
\title{Convert objects into sftrack objects.}
\usage{
as_sftrack(data = data.frame(), ...)

\method{as_sftrack}{data.frame}(
  data = data.frame(),
  ...,
  coords = c("x", "y"),
  group = "id",
  active_group = NA,
  time = "time",
  error = NA,
  crs = NA,
  zeroNA = FALSE,
  group_name = "sft_group",
  timestamp_name = "sft_timestamp",
  error_name = "sft_error",
  overwrite_names = FALSE
)

\method{as_sftrack}{sftraj}(data, ...)

\method{as_sftrack}{ltraj}(data, ...)

\method{as_sftrack}{sf}(
  data,
  ...,
  coords,
  group,
  active_group = NA,
  time,
  error = NA,
  group_name = "sft_group",
  timestamp_name = "sft_timestamp",
  error_name = "sft_error",
  overwrite_names = FALSE
)
}
\arguments{
\item{data}{a data.frame of the movement data, if supplied all data.frame inputs, than is optional}

\item{...}{extra information to be passed on to as_sftrack}

\item{coords}{a character vector describing where the x,y,z coordinates are located in `data` or a list with x,y,z (optional) vectors}

\item{group}{a list of named vectors describing multiple grouping variables or  a character vector naming the other grouping columns in `data`.}

\item{active_group}{a character vector of the burst names to be 'active' to group data by for analysis}

\item{time}{a vector of time information, can be either POSIX or an integer or a character string naming the column in `data` where the time information is located}

\item{error}{(optional) a vector of error information for the movement dataa character string naming the column in `data` where the error information is located}

\item{crs}{a crs string from rgdal of the crs and projection information for the spatial data. Defaults to NA}

\item{zeroNA}{logical whether to convert 0s in spatial data into NAs. Defaults to FALSE.}

\item{group_name}{(optional) new column name for grouping data}

\item{timestamp_name}{(optional) new column name for time data}

\item{error_name}{(optional) new column name for error data}

\item{overwrite_names}{T/F Whether to overwrite data if a group/time/error column name is supplied but already in data}
}
\description{
This function converts x,y,z data into an sftrack object with a sf_geometry column of sf_POINTS.
Creates a `grouping` column to group movement data and sets dedicated time and error columns.

Raw data inputted in two ways: vector or data.frame. 'Vector' inputs gives the argument as a vector where
length = nrow(data). 'Data.frame' inputs gives the arguments as the column name of `data` where the input can be found.
Either input is allowed on any given argument.

Some options are global and required regardless
}
\details{
Convert objects into sftrack objects.
}
\examples{
#'
data("raccoon")
raccoon$timestamp <- as.POSIXct(raccoon$timestamp, "EST")
burstz <- list(id = raccoon$animal_id, month = as.POSIXlt(raccoon$timestamp)$mon)
# Input is a data.frame
my_track <- as_sftrack(raccoon,
  group = burstz, time = "timestamp",
  error = NA, coords = c("longitude", "latitude")
)

# Input is a ltraj
library("adehabitatLT")
ltraj_df <- as.ltraj(
  xy = raccoon[, c("longitude", "latitude")],
  date = as.POSIXct(raccoon$timestamp),
  id = raccoon$animal_id, typeII = TRUE,
  infolocs = raccoon[, 1:6]
)

my_sftrack <- as_sftrack(ltraj_df)
head(my_sftrack)

# Input is a sf object
library("sf")
df1 <- raccoon[!is.na(raccoon$latitude), ]
sf_df <- st_as_sf(df1, coords = c("longitude", "latitude"))

new_sftrack <- as_sftrack(sf_df, group = c(id = "animal_id"), time = "timestamp")
head(new_sftrack)

# Input is an sftraj object
my_traj <- as_sftraj(raccoon,
  time = "timestamp",
  error = NA, coords = c("longitude", "latitude"),
  group = burstz
)

new_track <- as_sftrack(my_traj)
head(new_track)
######################
# Builder
}
