% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initGMF-class.R
\name{image.initgmf}
\alias{image.initgmf}
\title{Heatmap of an initialized GMF model}
\usage{
\method{image}{initgmf}(
  x,
  ...,
  type = c("data", "response", "link", "scores", "loadings", "deviance", "pearson",
    "working"),
  resid = FALSE,
  symmetric = FALSE,
  transpose = FALSE,
  limits = NULL,
  palette = NULL
)
}
\arguments{
\item{x}{an object of class \code{initgmf}}

\item{...}{further arguments passed to or from other methods}

\item{type}{the type of data/predictions/residuals which should be returned}

\item{resid}{if \code{TRUE}, plots the residual values}

\item{symmetric}{if \code{TRUE}, symmetrizes the color limits}

\item{transpose}{if \code{TRUE}, transposes the matrix before plotting it}

\item{limits}{the color limits which should be used}

\item{palette}{the color-palette which should be used}
}
\value{
A ggplot object showing the selected heatmap.
}
\description{
Plots a heatmap of either the data, the fitted values, or the residual values
of a GMF model allowing for different types of transformations and normalizations.
Moreover, it also permits to plot the latent score and loading matrices.
}
\examples{
\donttest{# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 100, m = 20, ncomp = 5, family = poisson())

# Fit a GMF model
init = sgdgmf.init(data$Y, ncomp = 3, family = poisson())

# Get the heatmap of a GMF model
image(init, type = "data") # original data
image(init, type = "response") # fitted values in response scale
image(init, type = "scores") # estimated score matrix
image(init, type = "loadings") # estimated loading matrix
image(init, type = "deviance", resid = TRUE) # deviance residual matrix
}
}
