% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{set.control.block.sgd}
\alias{set.control.block.sgd}
\title{Check and set the control parameters for the blockwise-SGD algorithm}
\usage{
set.control.block.sgd(
  normalize = TRUE,
  maxiter = 1000,
  eps = 1e-08,
  nafill = 10,
  tol = 1e-08,
  size = c(100, 100),
  burn = 1,
  rate0 = 0.01,
  decay = 0.01,
  damping = 0.001,
  rate1 = 0.1,
  rate2 = 0.01,
  verbose = FALSE,
  frequency = 250,
  progress = FALSE
)
}
\arguments{
\item{normalize}{if \code{TRUE}, normalize \code{U} and \code{V} to uncorrelated Gaussian \code{U} and upper triangular \code{V} with positive diagonal}

\item{maxiter}{maximum number of iterations}

\item{eps}{how much shrinkage has to be introduced on extreme predictions lying outside of the data range}

\item{nafill}{how frequently the \code{NA} values are filled, by default \code{NA} values are filled at each iteration of the algorithm}

\item{tol}{tolerance threshold for the stopping criterion}

\item{size}{mini-batch size, the first value is for row sub-sample, the second value is for column sub-sample}

\item{burn}{percentage of iterations to ignore before performing Polyak averaging}

\item{rate0}{initial learning rate}

\item{decay}{learning rate decay}

\item{damping}{regularization parameter which is added to the Hessian to ensure numerical stability}

\item{rate1}{exponential decay rate for the moment estimate of the gradient}

\item{rate2}{exponential decay rate for the moment estimate of the Hessian}

\item{verbose}{if \code{TRUE}, print the optimization status}

\item{frequency}{how often the optimization status is printed (only if \code{verbose=TRUE})}

\item{progress}{if \code{TRUE}, print a compact progress-bar instead of a full-report of the optimization status (only if \code{verbose=TRUE})}
}
\value{
A \code{list} of control parameters for the adaptive SGD algorithm with block-wise sub-sampling
}
\description{
Check if the input control parameters are allowed and set them to default
values if they are not. Returns a list of well-defined control parameters.
}
\examples{
library(sgdGMF)

# Empty call
set.control.block.sgd()

# Parametrized call
set.control.block.sgd(maxiter = 2000, rate0 = 0.01, decay = 0.01)


}
