% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgl_fit.R
\name{sgl_fit}
\alias{sgl_fit}
\title{Fit a Sparse Group Lasso Regularization Path.}
\usage{
sgl_fit(module_name, PACKAGE, data, parameterGrouping = NULL,
  groupWeights = NULL, parameterWeights = NULL, alpha, lambda,
  d = 100, compute_lambda = length(lambda) == 1,
  return_indices = NULL, algorithm.config = sgl.standard.config)
}
\arguments{
\item{module_name}{reference to objective specific C++ routines.}

\item{PACKAGE}{name of the calling package.}

\item{data}{a list of data objects -- will be parsed to the specified module.}

\item{parameterGrouping}{grouping of parameters, a vector of length \eqn{p}. Each element of the vector specifying the group of the parameters in the corresponding column of \eqn{\beta}.}

\item{groupWeights}{the group weights, a vector of length \code{length(unique(parameterGrouping))} (the number of groups).}

\item{parameterWeights}{a matrix of size \eqn{q \times p}.}

\item{alpha}{the \eqn{\alpha} value 0 for group lasso, 1 for lasso, between 0 and 1 gives a sparse group lasso penalty.}

\item{lambda}{lambda.min relative to lambda.max (if \code{compute_lambda = TRUE}) or the lambda sequence for the regularization path, a vector or a list of vectors (of the same length) with the lambda sequence for the subsamples.}

\item{d}{length of lambda sequence (ignored if \code{compute_lambda = FALSE})}

\item{compute_lambda}{should the lambda sequence be computed}

\item{return_indices}{the indices of lambda values for which to return fitted parameters.}

\item{algorithm.config}{the algorithm configuration to be used.}
}
\value{
\item{Y.true}{the response, that is the \code{y} object in data as created by \code{create.sgldata}.}
\item{beta}{the fitted parameters -- a list of length \code{length(return)} with each entry a matrix of size \eqn{q\times (p+1)} holding the fitted parameters.}
\item{loss}{the values of the loss function.}
\item{objective}{the values of the objective function (i.e. loss + penalty).}
\item{lambda}{the lambda values used.}
}
\description{
Computes a sequence of minimizers (one for each lambda given in the \code{lambda} argument) of
\deqn{\mathrm{loss}(\beta) + \lambda \left( (1-\alpha) \sum_{J=1}^m \gamma_J \|\beta^{(J)}\|_2 + \alpha \sum_{i=1}^{n} \xi_i |\beta_i| \right)}
where \eqn{\mathrm{loss}} is the loss/objective function specified by \code{module_name}.
The parameters are organized in the parameter matrix \eqn{\beta} with dimension \eqn{q\times p}.
The vector \eqn{\beta^{(J)}} denotes the \eqn{J} parameter group.
The group weights \eqn{\gamma \in [0,\infty)^m} and the parameter weights \eqn{\xi = (\xi^{(1)},\dots, \xi^{(m)}) \in [0,\infty)^n}
with \eqn{\xi^{(1)}\in [0,\infty)^{n_1},\dots, \xi^{(m)} \in [0,\infty)^{n_m}}.
}
\author{
Martin Vincent
}
