% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgo_points.R
\encoding{UTF-8}
\name{sgo_points}
\alias{sgo_points}
\alias{print.sgo_points}
\alias{as.data.frame.sgo_points}
\alias{as.list.sgo_points}
\title{Object containing 2D or 3D point coordinates}
\usage{
sgo_points(x, coords = NULL, epsg = NULL)

\method{print}{sgo_points}(x, ..., n = 6L)

\method{as.data.frame}{sgo_points}(x, row.names = NULL, optional = FALSE, ...)

\method{as.list}{sgo_points}(x, ...)
}
\arguments{
\item{x}{A matrix, list or dataframe with at least 2 columns of either
easting/northing or longitude/latitude coordinates per row. A column with
height values is optional.
\strong{Please note} that the order is important when \code{x} has only 2 or
3 columns and \code{coords} is not informed: lat/lon or northing/easting
(and height) will produce wrong results.}

\item{coords}{A vector with the names of the two or three columns containing
the X (easting or longitude), Y (northing or latitude) and optionally Z
(ellipsoid or orthometric height) coordinates.}

\item{epsg}{Specifies the EPSG code of coordinates to store. It can take any
of the following values:
\itemize{
\item when working with (2D/3D) ETRS89 Datum: \code{4258}, \code{4937},
\code{4936}, \code{3035}
\item when working with (2D/3D) WGS84 Datum:\code{4326}, \code{4979},
\code{4978}
\item when working with (2D/3D) OSGB36 Datum:\code{4277}, \code{27700},
\code{7405}
\item WGS84/Pseudo-Mercator (Google Maps, OpenStreetMap, etc.): \code{3857}
}}

\item{...}{Further arguments passed to or from other methods,
see \link{print}, \link{as.data.frame} or \link{as.list} .}

\item{n}{Maximum number of features to print.}

\item{row.names}{NULL or a character vector giving the row names for the
data frame. Missing values are not allowed.}

\item{optional}{Logical. See \link{as.data.frame}}
}
\value{
An object of class \code{sgo_points}. This object is a actually a list with
class \code{sgo_points} and 5 elements (or 6 elements if it is 3D):
\itemize{
\item\code{x}: A numeric vector containing easting or longitude coordinates.
\item\code{y}: A numeric vector with northing or latitude coordintes.
\item\code{z}: A numeric vector with height values when the object is 3D.
\item\code{epsg}: A scalar value with the EPSG code of the current
Geographic Coordinate System (GCS).
\item\code{datum}: A string describing the geodetic datum that defines the
GCS of the object. Currently can take the values "OSGB36", "WGS84" or
"ETRS89"
\item\code{dimension}: A string describing whether the object is 2D or 3D.
It can take the values "XY" or "XYZ".
}
}
\description{
2D or 3D coordinates (and other attributes) of a point or collection of
points
}
\details{
This object stores 2D or 3D point coordinates and any other column-list of
attributes related to each point. Note that additional column-lists will be
expanded with \code{NA} values if they contain less elements than
coordinates. Currently it only supports the following \code{epsg}s:
\itemize{
\item\code{4258}: ETRS89, geodetic coordinate system. The columns in
\code{x} must be defined as Longitude and Latitude (\code{sgo} also accepts
a third column for ellipsoid heights). The defined datum for this set of
coordinates is ETRS89 (https://epsg.io/4258).

\item\code{4937}: ETRS89, geodetic coordinate system. The columns in
\code{x} must be defined as Longitude, Latitude and Ellipsoid Heights
respectively. The defined datum for this set of coordinates is ETRS89
(https://epsg.io/4937).

\item\code{4936}: ETRS89, geodetic coordinate system. The columns in
\code{x} must be defined as cartesian coordinates x, y and z. The defined
datum for this set of coordinates is ETRS89 (https://epsg.io/4936).

\item\code{3035}: ETRS-LAEA, projected coordinate system. The
columns in \code{x} must be defined as Easting and Northing. The defined
datum for this set of coordinates is WGS84 (https://epsg.io/3035)

\item\code{4326}: WGS84, geodetic coordinate system. The columns in \code{x}
must be defined as Longitude and Latitude (\code{sgo} also accepts a
third column for ellipsoid heights). The defined datum for this set of
coordinates is WGS84 (https://epsg.io/4326).

\item\code{4979}: WGS84, geodetic coordinate system. The columns in \code{x}
must be defined as Longitude, Latitude and Ellipsoid Height respectively.
The defined datum for this set of coordinates is WGS84 (https://epsg.io/4979)

\item\code{4978}: WGS84, geodetic coordinate system. The columns in \code{x}
must be defined as cartesian coordinates x, y and z. The
defined datum for this set of coordinates is WGS84 (https://epsg.io/4978)

\item\code{4277}: OSGB36, geodetic coordinate system. The 2 columns in
\code{x} must be defined as Longitude and Latitude values respectively. The
defined datum for this set of coordinates is OSGB 1936
(https://epsg.io/4277). \emph{Coordinates defined like this should only be
used for historical reasons and to convert only to or from BNG coordinates.}
\strong{Height values will be discarded when working with this coordinate
system.}

\item\code{27700}: British National Grid, projected coordinate system. The
columns in \code{x} must be defined as Easting and Northing (\code{sgo} also
accepts a third column for orthometric heights). The defined datum for this
set of coordinates is OSGB 1936 (https://epsg.io/27700).

\item\code{7405}: British National Grid, projected coordinate system. The
columns in \code{x} must be defined as Easting, Northing and ODN Orthometric
height respectively (\code{sgo} accepts heights from other datums like
Orkney, Lerwick, Stornoway, Douglas, St.Marys and 'Newlyn offshore').
The defined datum for this set of coordinates is OSGB 1936
(https://epsg.io/7405).

\item\code{3857}: WGS 84 / Pseudo-Mercator, projected coordinate system. The
columns in \code{x} must be defined as Easting and Northing. The defined
datum for this set of coordinates is WGS84 (https://epsg.io/3857)
}
}
\examples{
# lists:
p1 <- sgo_points(list(-3.9369, 56.1165), epsg=4326)
lon <- c(-4.25181,-3.18827)
lat <- c(55.86424, 55.95325)
p2 <- sgo_points(list(longitude=lon, latitude=lat), epsg=4326)
#p3 will fill up the list 'desc' with NA's to have the same number of
#elements as coordinates in the list:
p3 <- sgo_points(list(longitude=lon, latitude=lat, desc="c1"),
                 coords=c("longitude", "latitude"), epsg=4326)
# dataframe:
ln <- c(-4.22472, -2.09908)
lt <- c(57.47777, 57.14965)
n <- c("Inverness", "Aberdeen")
df <- data.frame(n, ln, lt, stringsAsFactors = FALSE)
p4 <- sgo_points(df, coords=c("ln", "lt"), epsg=4326)

# plotting on a map:
if (require(maps)) {
  map('world', regions=('uk'), xlim=c(-9, 0), ylim=c(54.5, 60.9))
  points(x=p1$x, y=p1$y, pch=0, col="green") #Stirling
  points(p4, pch=0, col="red")
  text(p4, labels=p4$n, pos=1, cex=0.9)
}
}
\seealso{
\code{\link{sgo_coordinates}}, \code{\link{sgo_transform}}.
}
