% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgo_laea.R
\encoding{UTF-8}
\name{sgo_etrs_laea}
\alias{sgo_etrs_laea}
\title{ETRS89 to ETRS89-LAEA Easting/Northing}
\usage{
sgo_etrs_laea(x)
}
\arguments{
\item{x}{A \code{sgo_points} object describing a set of points in the
geodetic coordinate system EPSG=4258, 4937 or 4936.}
}
\value{
An object of class \code{sgo_points} whose coordinates are defined as
Easting/Northing in the EPSG:3035 Projected Coordinate System.
}
\description{
Converts ETRS89 geodetic coordinates to ETRS89-LAEA Easting/Northing
(EPSG:3035)
}
\details{
ETRS89-LAEA (EPSG:3035) is a CRS for pan-European statistical mapping at all
scales or other purposes where true area representation is required.
}
\examples{
p <- sgo_points(list(-3.9369, 56.1165), epsg=4258)
prj <- sgo_etrs_laea(p)
}
\references{
IOGP Publication 373-7-2 - Geomatics Guidance Note number 7,
part 2 (October 2020). https://epsg.org/guidance-notes.html)
}
\seealso{
\code{\link{sgo_points}}, \code{\link{sgo_area}}.
}
