% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surfaceGrid.R
\name{surfaceGrid}
\alias{surfaceGrid}
\title{Create grid of 3D points covering the 'facades' and 'roofs' of obstacles}
\usage{
surfaceGrid(obstacles, obstacles_height_field, res, offset = 0.01)
}
\arguments{
\item{obstacles}{A \code{SpatialPolygonsDataFrame} object specifying the obstacles outline}

\item{obstacles_height_field}{Name of attribute in \code{obstacles} with extrusion height for each feature}

\item{res}{Required grid resolution, in CRS units}

\item{offset}{Offset between grid points and facade (horizontal distance) or between grid points and roof (vertical distance).}
}
\value{
A 3D \code{SpatialPointsDataFrame} layer, including all attributes of the original obstacles each surface point corresponds to, followed by six new attributes:\itemize{
\item{\code{obs_id} Unique consecutive ID for each feature in \code{obstacles}}
\item{\code{type} Either \code{"facade"} or \code{"roof"}}
\item{\code{seg_id} Unique consecutive ID for each facade segment (only for 'facade' points)}
\item{\code{xy_id} Unique consecutive ID for each ground location (only for 'facade' points)}
\item{\code{facade_az} The azimuth of the corresponding facade, in decimal degrees (only for 'facade' points)}
}
}
\description{
The function creates a grid of 3D points covering the given obstacles at specified resolution. Such a grid can later on be used to quantify the shaded / non-shaded proportion of the obstacles surface area.
}
\note{
The reason for introducing an offset is to avoid ambiguity as for whether the grid points are "inside" or "outside" of the obstacle. With an offset all grid points are "outside" of the building and thus not intersecting it. \code{offset} should be given in CRS units; default is 0.01.
}
\examples{
grid = surfaceGrid(
  obstacles = rishon,
  obstacles_height_field = "BLDG_HT",
  res = 2,
  offset = 0.01
)

}
\seealso{
Function \code{\link{plotGrid}} to visualize grid.
}
