% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapviz.R
\name{from_xgb_or_lgb}
\alias{from_xgb_or_lgb}
\alias{shapviz_from_xgb_predict}
\alias{shapviz_from_lgb_predict}
\title{Initialize "shapviz" Object from XGBoost/LightGBM Predict}
\usage{
shapviz_from_xgb_predict(S, X, which_class = NULL, ...)

shapviz_from_lgb_predict(S, X, which_class = NULL, ...)
}
\arguments{
\item{S}{Output of calling \code{predict(..., predcontrib = TRUE)}.}

\item{X}{Matrix or data.frame of feature values corresponding to \code{S}.}

\item{which_class}{In case of a multiclass setting, which class >= 1 to be explained.}

\item{...}{Other parameters passed (currently unused).}
}
\value{
An object of class "shapviz".
}
\description{
These functions create an object of class "shapviz" by taking the output of
\code{predict(..., predcontrib = TRUE)} of an XGBoost or LightGBM model,
together with a matrix/data.frame \code{X} representing the corresponding
feature values. These functions are mainly written for internal use
but they can be useful if SHAP values have already been computed.
Note that the SHAP matrix returned by LightGBM does not provide column names.
Thus, you need to be absolutely sure that the column names of \code{X}
correspond to the column names originally passed to \code{predict()}.
}
\examples{
X_pred <- data.matrix(iris[, -1])
dtrain <- xgboost::xgb.DMatrix(X_pred, label = iris[, 1])
fit <- xgboost::xgb.train(data = dtrain, nrounds = 50)
shap_values <- predict(fit, dtrain, predcontrib = TRUE)
x <- shapviz_from_xgb_predict(shap_values, iris[, -1])
}
