% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_waterfall.R
\name{sv_waterfall}
\alias{sv_waterfall}
\alias{sv_waterfall.default}
\alias{sv_waterfall.shapviz}
\alias{sv_waterfall.mshapviz}
\title{SHAP Waterfall Plot}
\usage{
sv_waterfall(object, ...)

\method{sv_waterfall}{default}(object, ...)

\method{sv_waterfall}{shapviz}(
  object,
  row_id = 1L,
  max_display = 10L,
  order_fun = function(s) order(abs(s)),
  fill_colors = c("#f7d13d", "#a52c60"),
  format_shap = getOption("shapviz.format_shap"),
  format_feat = getOption("shapviz.format_feat"),
  contrast = TRUE,
  show_connection = TRUE,
  show_annotation = TRUE,
  annotation_size = 3.2,
  ...
)

\method{sv_waterfall}{mshapviz}(
  object,
  row_id = 1L,
  max_display = 10L,
  order_fun = function(s) order(abs(s)),
  fill_colors = c("#f7d13d", "#a52c60"),
  format_shap = getOption("shapviz.format_shap"),
  format_feat = getOption("shapviz.format_feat"),
  contrast = TRUE,
  show_connection = TRUE,
  show_annotation = TRUE,
  annotation_size = 3.2,
  ...
)
}
\arguments{
\item{object}{An object of class "(m)shapviz".}

\item{...}{Arguments passed to \code{\link[ggfittext:geom_fit_text]{ggfittext::geom_fit_text()}}.
For example, \code{size = 9} will use fixed text size in the bars and \code{size = 0}
will altogether suppress adding text to the bars.}

\item{row_id}{Subset of observations to plot, typically a single row number.
If more than one row is selected, SHAP values are averaged, and feature values
are shown only when they are unique.}

\item{max_display}{Maximum number of features (with largest absolute SHAP values)
should be plotted? If there are more features, they will be collapsed to one
feature. Set to \code{Inf} to show all features.}

\item{order_fun}{Function specifying the order of the variables/SHAP values.
It maps the vector \code{s} of SHAP values to sort indices from 1 to \code{length(s)}.
The default is \code{function(s) order(abs(s))}. To plot without sorting, use
\code{function(s) 1:length(s)} or \code{function(s) length(s):1}.}

\item{fill_colors}{A vector of exactly two fill colors: the first for positive
SHAP values, the other for negative ones.}

\item{format_shap}{Function used to format SHAP values. The default uses the
global option \code{shapviz.format_shap}, which equals to
\code{function(z) prettyNum(z, digits = 3, scientific = FALSE)} by default.}

\item{format_feat}{Function used to format numeric feature values. The default uses
the global option \code{shapviz.format_feat}, which equals to
\code{function(z) prettyNum(z, digits = 3, scientific = FALSE)} by default.}

\item{contrast}{Logical flag that detemines whether to use white text in dark arrows.
Default is \code{TRUE}.}

\item{show_connection}{Should connecting lines be shown? Default is \code{TRUE}.}

\item{show_annotation}{Should "f(x)" and "E(f(x))" be plotted? Default is \code{TRUE}.}

\item{annotation_size}{Size of the annotation text (f(x)=... and E(f(x))=...).}
}
\value{
An object of class "ggplot" (or "patchwork") representing a waterfall plot.
}
\description{
Creates a waterfall plot of SHAP values of one observation. If multiple
observations are selected, their SHAP values and predictions are averaged.
}
\details{
f(x) denotes the prediction on the SHAP scale, while E(f(x)) refers to the
baseline SHAP value.
}
\section{Methods (by class)}{
\itemize{
\item \code{sv_waterfall(default)}: Default method.

\item \code{sv_waterfall(shapviz)}: SHAP waterfall plot for an object of class "shapviz".

\item \code{sv_waterfall(mshapviz)}: SHAP waterfall plot for an object of class "mshapviz".

}}
\examples{
dtrain <- xgboost::xgb.DMatrix(data.matrix(iris[, -1L]), label = iris[, 1L])
fit <- xgboost::xgb.train(data = dtrain, nrounds = 50L, nthread = 1L)
x <- shapviz(fit, X_pred = dtrain, X = iris[, -1])
sv_waterfall(x)
sv_waterfall(x, row_id = 123, max_display = 2L, size = 9, fill_colors = 4:5)

# Ordered by colnames(x), combined with max_display
sv_waterfall(
  x[, sort(colnames(x))], order_fun = function(s) length(s):1, max_display = 3L
)

# Aggregate over all observations with Petal.Length == 1.4
sv_waterfall(x, row_id = x$X$Petal.Length == 1.4)

# More features
X <- as.data.frame(matrix(1:100, nrow = 10L))
S <- as.matrix(X)
shp <- shapviz(S, X)
sv_waterfall(shp)

# Combine two waterfall plots via {patchwork}
sv_waterfall(c(Obs1 = x[1L], Obs2 = x[2L])) +
  patchwork::plot_layout(ncol = 1L)
}
\seealso{
\code{\link[=sv_force]{sv_force()}}
}
