% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelisation.R
\name{Combine}
\alias{Combine}
\title{Merging stability selection outputs}
\usage{
Combine(stability1, stability2, include_beta = TRUE)
}
\arguments{
\item{stability1}{output from a first run of \code{\link{VariableSelection}}
or \code{\link{GraphicalModel}}.}

\item{stability2}{output from a second run of \code{\link{VariableSelection}}
or \code{\link{GraphicalModel}}.}

\item{include_beta}{logical indicating if the beta coefficients of visited
models should be concatenated. Only applicable to variable selection.}
}
\value{
A single output of the same format.
}
\description{
Merges the outputs from \code{\link{VariableSelection}} or
\code{\link{GraphicalModel}}. The two runs must have been done using the same
\code{methods} and the same \code{params} but with different \code{seed}s.
The combined output will contain results based on iterations from both
\code{stability1} and \code{stability2}. This function can be used for
parallelisation.
}
\examples{
\donttest{
## Variable selection

# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 100, pk = 50, family = "gaussian")

# Two runs
stab1 <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata, seed = 1, K = 10)
stab2 <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata, seed = 2, K = 10)

# Merging the outputs
stab <- Combine(stability1 = stab1, stability2 = stab2, include_beta = FALSE)
print(stab)


## Graphical modelling

# Data simulation
simul <- SimulateGraphical(pk = 20)

# Two runs
stab1 <- GraphicalModel(xdata = simul$data, seed = 1, K = 10)
stab2 <- GraphicalModel(xdata = simul$data, seed = 2, K = 10)

# Merging the outputs
stab <- Combine(stability1 = stab1, stability2 = stab2)
print(stab)
}
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{GraphicalModel}}
}
