% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalised_models.R
\name{OpenMxModel}
\alias{OpenMxModel}
\title{Writing OpenMx model (matrix specification)}
\usage{
OpenMxModel(adjacency, residual_covariance = NULL, manifest = NULL)
}
\arguments{
\item{adjacency}{binary adjacency matrix of the Directed Acyclic Graph
(transpose of the asymmetric matrix A in Reticular Action Model notation).
The row and column names of this matrix must be defined.}

\item{residual_covariance}{binary and symmetric matrix encoding the nonzero
entries in the residual covariance matrix (symmetric matrix S in Reticular
Action Model notation). By default, this is the identity matrix (no
residual covariance).}

\item{manifest}{optional vector of manifest variable names.}
}
\value{
A character string that can be used in argument \code{model} in
  \code{\link[lavaan]{sem}}.
}
\description{
Returns matrix specification for use in \code{\link[OpenMx]{mxModel}} from
(i) the adjacency matrix of a Directed Acyclic Graph (asymmetric matrix A in
Reticular Action Model notation), and (ii) a binary matrix encoding nonzero
entries in the residual covariance matrix (symmetric matrix S in Reticular
Action Model notation).
}
\examples{
if (requireNamespace("OpenMx", quietly = TRUE)) {
  # Definition of simulated effects
  pk <- c(3, 2, 3)
  dag <- LayeredDAG(layers = pk)
  theta <- dag
  theta[2, 4] <- 0
  theta[3, 7] <- 0
  theta[4, 7] <- 0

  # Data simulation
  set.seed(1)
  simul <- SimulateStructural(n = 500, v_between = 1, theta = theta, pk = pk)

  # Writing RAM matrices for mxModel
  ram_matrices <- OpenMxModel(adjacency = dag)

  # Running unpenalised model
  unpenalised <- OpenMx::mxRun(OpenMx::mxModel(
    "Model",
    OpenMx::mxData(simul$data, type = "raw"),
    ram_matrices$Amat,
    ram_matrices$Smat,
    ram_matrices$Fmat,
    ram_matrices$Mmat,
    OpenMx::mxExpectationRAM("A", "S", "F", "M", dimnames = colnames(dag)),
    OpenMx::mxFitFunctionML()
  ), silent = TRUE, suppressWarnings = TRUE)
  unpenalised$A$values

  # Incorporating latent variables
  ram_matrices <- OpenMxModel(
    adjacency = dag,
    manifest = paste0("x", 1:7)
  )
  ram_matrices$Fmat$values

  # Running unpenalised model
  unpenalised <- OpenMx::mxRun(OpenMx::mxModel(
    "Model",
    OpenMx::mxData(simul$data[, 1:7], type = "raw"),
    ram_matrices$Amat,
    ram_matrices$Smat,
    ram_matrices$Fmat,
    ram_matrices$Mmat,
    OpenMx::mxExpectationRAM("A", "S", "F", "M", dimnames = colnames(dag)),
    OpenMx::mxFitFunctionML()
  ), silent = TRUE, suppressWarnings = TRUE)
  unpenalised$A$values
}
}
\seealso{
\code{\link{PenalisedOpenMx}}, \code{\link{OpenMxMatrix}}
}
