% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_algorithms.R
\name{UnweightedKMeansClustering}
\alias{UnweightedKMeansClustering}
\title{Unweighted K-means clustering}
\usage{
UnweightedKMeansClustering(xdata, nc = NULL, ...)
}
\arguments{
\item{xdata}{data matrix with observations as rows and variables as columns.}

\item{nc}{matrix of parameters controlling the number of clusters in the
underlying algorithm specified in \code{implementation}. If \code{nc} is
not provided, it is set to \code{seq(1, tau*nrow(xdata))}.}

\item{...}{additional parameters passed to \code{\link[stats]{kmeans}}.}
}
\value{
A list with: \item{comembership}{an array of binary and symmetric
  co-membership matrices.} \item{weights}{a matrix of median weights by
  feature.}
}
\description{
Runs k-means clustering using implementation from
\code{\link[stats]{kmeans}}. This function is not using stability.
}
\keyword{internal}
