% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{Coefficients}
\alias{Coefficients}
\title{Model coefficients}
\usage{
Coefficients(stability, side = "X", comp = 1, iterations = NULL)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}}.}

\item{side}{character string indicating if coefficients of the predictor
(\code{side="X"}) or outcome (\code{side="Y"}) coefficients should be
returned. Option \code{side="Y"} is only applicable to PLS models.}

\item{comp}{component ID. Only applicable to PLS models.}

\item{iterations}{vector of iteration IDs. If \code{iterations=NULL}, the
coefficients of all visited models are returned. This number must be
smaller than the number of iterations \code{K} used for the stability
selection run.}
}
\description{
Extracts the coefficients of visited models at different resampling
iterations of a stability selection run. This function can be applied to the
output of \code{\link{VariableSelection}}.
}
\seealso{
\code{\link{VariableSelection}}
}
\keyword{internal}
