% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorMixtureVenn.R
\name{colorMixtureVenn}
\alias{colorMixtureVenn}
\title{Create a Venn Diagram of Simulated Color Mixtures}
\usage{
colorMixtureVenn(
  chips,
  mixingMethod = "spectra",
  ellipse = FALSE,
  labels = TRUE
)
}
\arguments{
\item{chips}{character vector of standard Munsell color notation (e.g. "10YR 3/4")}

\item{mixingMethod}{approach used to simulate a mixture: see \code{aqp::mixMunsell} for details}

\item{ellipse}{logical, use alternative ellipse-style (4 or 5 colors only)}

\item{labels}{logical, print mixture labels}
}
\description{
Create a Venn Diagram of Simulated Color Mixtures
}
\examples{

if(requireNamespace("venn") & requireNamespace("gower")) {

# "tan" / "dark red" / "dark brown"
chips <- c('10YR 8/1', '2.5YR 3/6', '10YR 2/2')
colorMixtureVenn(chips)

}
}
